/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.test;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.test.framework.MIGameTest;
import aztech.modern_industrialization.test.framework.MIGameTestHelper;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidPipeTests {
    private final PipeNetworkType fluidPipe = PipeNetworkType.get(MI.id("fluid_pipe"));

    @MIGameTest
    public void testSinglePipeThroughput(MIGameTestHelper helper) {
        helper.creativeTank(new BlockPos(0, 1, 0), (Fluid)Fluids.WATER);
        BlockPos tankToFill = new BlockPos(2, 1, 0);
        helper.emptyTank(tankToFill);
        helper.pipe(new BlockPos(1, 1, 0), this.fluidPipe, pipe -> {
            pipe.addInConnection(Direction.EAST);
            pipe.addOutConnection(Direction.WEST);
        });
        helper.startSequence().thenIdle(1).thenExecute(() -> helper.assertFluid(tankToFill, (Fluid)Fluids.WATER, 1000)).thenSucceed();
    }

    @MIGameTest
    public void testDoublePipeThroughput(MIGameTestHelper helper) {
        helper.creativeTank(new BlockPos(0, 1, 0), (Fluid)Fluids.WATER);
        BlockPos tankToFill = new BlockPos(2, 1, 0);
        helper.emptyTank(tankToFill);
        helper.pipe(new BlockPos(1, 1, 0), this.fluidPipe, pipe -> {
            pipe.addInConnection(Direction.EAST);
            pipe.addOutConnection(Direction.WEST);
        });
        helper.pipe(new BlockPos(1, 2, 0), this.fluidPipe, pipe -> {});
        helper.startSequence().thenIdle(1).thenExecute(() -> helper.assertFluid(tankToFill, (Fluid)Fluids.WATER, 2000)).thenSucceed();
    }

    @MIGameTest
    public void testTankExtendedThroughput(MIGameTestHelper helper) {
        helper.creativeTank(new BlockPos(0, 1, 0), (Fluid)Fluids.WATER);
        BlockPos tankToFill = new BlockPos(2, 1, 0);
        helper.emptyTank(tankToFill);
        BlockPos extensionTank = new BlockPos(1, 2, 0);
        helper.emptyTank(extensionTank, MIMaterials.BRONZE);
        BlockPos pipePos = new BlockPos(1, 1, 0);
        helper.pipe(pipePos, this.fluidPipe, pipe -> {
            pipe.addInConnection(Direction.EAST);
            pipe.addOutConnection(Direction.WEST);
            pipe.addInOutConnection(Direction.UP);
        });
        helper.startSequence().thenIdle(1).thenExecute(() -> {
            helper.assertFluid(tankToFill, (Fluid)Fluids.WATER, 5000);
            helper.assertNoFluid(extensionTank);
        }).thenExecute(() -> helper.emptyTank(tankToFill, MIMaterials.BRONZE)).thenIdle(1).thenExecute(() -> {
            helper.assertFluid(tankToFill, (Fluid)Fluids.WATER, 4000);
            helper.assertFluid(extensionTank, (Fluid)Fluids.WATER, 800);
            FluidNetworkNode node = (FluidNetworkNode)helper.getPipeNode(pipePos, this.fluidPipe);
            if (node.getAmount() != 200L) {
                helper.fail("Expected 200 fluid in pipe, got " + node.getAmount(), pipePos);
            }
        }).thenExecute(() -> {
            helper.destroyBlock(tankToFill);
            helper.emptyTank(tankToFill, MIMaterials.BRONZE);
            helper.destroyBlock(extensionTank);
            helper.emptyTank(extensionTank, MIMaterials.BRONZE);
            TankBlockEntity tank = (TankBlockEntity)helper.getBlockEntity(extensionTank);
            try (Transaction tx = Transaction.openOuter();){
                tank.insert(FluidVariant.of((Fluid)Fluids.LAVA), 1000L, (TransactionContext)tx);
                tank.toggleLocked();
            }
        }).thenIdle(1).thenExecute(() -> {
            helper.assertFluid(tankToFill, (Fluid)Fluids.WATER, 1000);
            helper.assertNoFluid(extensionTank);
        }).thenSucceed();
    }
}

