/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.machines.components.NuclearEfficiencyHistoryComponent;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class NuclearFuel
extends NuclearAbsorbable {
    public final double directEnergyFactor;
    public final double neutronMultiplicationFactor;
    public final ResourceLocation depletedVersionId;
    public final int size;
    public final int directEUbyDesintegration;
    public final int totalEUbyDesintegration;
    public final int tempLimitLow;
    public final int tempLimitHigh;

    public NuclearFuel(Item.Properties settings, NuclearFuelParams params, INeutronBehaviour neutronBehaviour, ResourceLocation depletedVersionId) {
        this(settings, params.desintegrationMax, params.maxTemperature, params.tempLimitLow, params.tempLimitHigh, params.neutronMultiplicationFactor, params.directEnergyFactor, neutronBehaviour, params.size, depletedVersionId);
    }

    private static int clampTemp(int temperature) {
        return 25 * (int)((double)temperature / 25.0);
    }

    private NuclearFuel(Item.Properties settings, int desintegrationMax, int maxTemperature, int tempLimitLow, int tempLimitHigh, double neutronMultiplicationFactor, double directEnergyFactor, INeutronBehaviour neutronBehaviour, int size, ResourceLocation depletedVersionId) {
        super(settings, NuclearFuel.clampTemp(maxTemperature), 0.008, neutronBehaviour, desintegrationMax);
        this.size = size;
        this.directEnergyFactor = directEnergyFactor;
        this.neutronMultiplicationFactor = neutronMultiplicationFactor;
        this.depletedVersionId = depletedVersionId;
        this.tempLimitLow = NuclearFuel.clampTemp(tempLimitLow);
        this.tempLimitHigh = NuclearFuel.clampTemp(tempLimitHigh);
        this.directEUbyDesintegration = (int)(8.0 * directEnergyFactor * neutronMultiplicationFactor);
        this.totalEUbyDesintegration = (int)(8.0 * (1.0 + directEnergyFactor) * neutronMultiplicationFactor);
    }

    public static ItemDefinition<NuclearFuel> of(String englishName, String id, NuclearFuelParams params, INeutronBehaviour neutronBehaviour, String depletedVersionId, SortOrder sortOrder) {
        return MIItem.item(englishName, id, settings -> new NuclearFuel(settings.stacksTo(1), params, neutronBehaviour, MI.id(depletedVersionId)), sortOrder);
    }

    @Override
    public ItemVariant getNeutronProduct() {
        return ItemVariant.of((ItemLike)BuiltInRegistries.ITEM.getOptional(this.depletedVersionId).get());
    }

    @Override
    public long getNeutronProductAmount() {
        return this.size;
    }

    public double efficiencyFactor(double temperature) {
        double factor = 1.0;
        if (temperature > (double)this.tempLimitLow) {
            factor = Math.max(0.0, 1.0 - (temperature - (double)this.tempLimitLow) / (double)(this.tempLimitHigh - this.tempLimitLow));
        }
        return factor;
    }

    public int simulateDesintegration(double neutronsReceived, ItemStack stack, double temperature, RandomSource rand, NuclearEfficiencyHistoryComponent efficiencyHistory) {
        int absorption = this.simulateAbsorption(neutronsReceived, stack, rand);
        double fuelEuConsumed = absorption * this.totalEUbyDesintegration;
        efficiencyHistory.registerEuFuelConsumption(fuelEuConsumed);
        return NuclearFuel.randIntFromDouble(this.efficiencyFactor(temperature) * (double)absorption * this.neutronMultiplicationFactor, rand);
    }

    public record NuclearFuelParams(int desintegrationMax, int maxTemperature, int tempLimitLow, int tempLimitHigh, double neutronMultiplicationFactor, double directEnergyFactor, int size) {
    }
}

