/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SmeltingRecipeBuilder
implements MaterialRecipeBuilder {
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    @Nullable
    private final AbstractCookingRecipe smeltingRecipe;

    public static void smeltAndBlast(MaterialBuilder.RecipeContext context, PartKeyProvider inputPart, PartKeyProvider outputPart, float experience) {
        if (context.hasInternalPart(inputPart) || context.hasInternalPart(outputPart)) {
            new SmeltingRecipeBuilder(context, inputPart, outputPart, experience, false);
            new SmeltingRecipeBuilder(context, inputPart, outputPart, experience, true);
        }
    }

    public SmeltingRecipeBuilder(MaterialBuilder.RecipeContext context, PartKeyProvider inputPart, PartKeyProvider outputPart, int cookingtime, float experience, boolean blasting) {
        this.recipeId = blasting ? "smelting/" + String.valueOf(inputPart.key()) + "_to_" + String.valueOf(outputPart.key()) + "_blasting" : "smelting/" + String.valueOf(inputPart.key()) + "_to_" + String.valueOf(outputPart.key()) + "_smelting";
        this.context = context;
        MaterialItemPart input = context.getPart(inputPart);
        MaterialItemPart output = context.getPart(outputPart);
        if (input == null || output == null) {
            this.canceled = true;
            this.smeltingRecipe = null;
        } else {
            AbstractCookingRecipe.Factory factory = blasting ? BlastingRecipe::new : SmeltingRecipe::new;
            this.smeltingRecipe = factory.create("", CookingBookCategory.MISC, Ingredient.of((ItemLike[])new ItemLike[]{input.asItem()}), output.asItem().getDefaultInstance(), experience, cookingtime);
            context.addRecipe(this);
        }
    }

    public SmeltingRecipeBuilder(MaterialBuilder.RecipeContext context, PartKeyProvider partInput, PartKeyProvider partOutput, float experience, boolean blasting) {
        this(context, partInput, partOutput, blasting ? 100 : 200, experience, blasting);
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void save(RecipeOutput recipeOutput) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            recipeOutput.accept(MI.id(fullId), (Recipe)this.smeltingRecipe, null);
        }
    }
}

