/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.set.MaterialRawSet;
import java.util.List;

public record RawMetalPart(boolean isBlock) implements PartKeyProvider
{
    public PartTemplate of(MaterialRawSet set) {
        PartTemplate part = new PartTemplate(this.isBlock ? "Block of Raw %s" : "Raw %s", this.key());
        if (this.isBlock) {
            return part.asBlock(SortOrder.RAW_ORE_BLOCKS, new TextureGenParams.RawMetal(true, set), 5.0f, 6.0f, 1).withCustomPath("raw_%s_block", "storage_blocks/raw_%s");
        }
        return part.withTexture(new TextureGenParams.RawMetal(false, set)).withCustomPath("raw_%s", "raw_materials/%s");
    }

    public List<PartTemplate> ofAll(MaterialRawSet set) {
        return List.of(MIParts.RAW_METAL.of(set), MIParts.RAW_METAL_BLOCK.of(set));
    }

    @Override
    public PartKey key() {
        return new PartKey("raw_metal" + (this.isBlock ? "_block" : ""));
    }
}

