/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotItemHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class BarrelPart
implements PartKeyProvider {
    @Override
    public PartKey key() {
        return new PartKey("barrel");
    }

    public PartTemplate of(String nameOverride, String pathOverride, int stackCapacity) {
        return this.of(new PartEnglishNameFormatter.Overridden(nameOverride), Long.valueOf(stackCapacity), pathOverride);
    }

    public PartTemplate of(long stackCapacity) {
        return this.of(new PartEnglishNameFormatter.Default("Barrel"), stackCapacity, null);
    }

    private PartTemplate of(PartEnglishNameFormatter englishNameFormatter, Long stackCapacity, @Nullable String maybeOverriddenPath) {
        MutableObject bet = new MutableObject();
        PartTemplate template = new PartTemplate(englishNameFormatter, this.key()).asColumnBlock(SortOrder.BARRELS).withRegister((partContext, part, itemPath, itemId, itemTag, englishName) -> {
            BarrelBlock.BarrelStorage barrelStorageBehaviour = BarrelBlock.withStackCapacity(stackCapacity);
            EntityBlock factory = (pos, state) -> new BarrelBlockEntity((BlockEntityType)bet.getValue(), pos, state);
            BlockDefinition<BarrelBlock> blockDefinition = MIBlock.block(englishName, itemPath, MIBlock.BlockDefinitionParams.defaultStone().withBlockConstructor(s -> new BarrelBlock(factory, barrelStorageBehaviour)).withBlockItemConstructor(BarrelItem::new).withModel((block, gen) -> {
                String name = gen.name((Block)block);
                gen.simpleBlock(block, (ModelFile)gen.models().cubeColumn(name, gen.blockTexture(name + "_side"), gen.blockTexture(name + "_top")));
            }).withBlockEntityRendererItemModel().noLootTable().sortOrder(SortOrder.BARRELS.and(stackCapacity)));
            TagsToGenerate.generateTag(MITags.BARRELS, blockDefinition, "Barrels");
            MIRegistries.BLOCK_ENTITIES.register(itemPath, () -> {
                BlockEntityType ret = BlockEntityType.Builder.of((arg_0, arg_1) -> ((EntityBlock)factory).newBlockEntity(arg_0, arg_1), (Block[])new Block[]{blockDefinition.asBlock()}).build(null);
                bet.setValue((Object)ret);
                return ret;
            });
            MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)bet.getValue(), (be, side) -> new SlotItemHandler((SingleSlotStorage<ItemVariant>)be)));
            CommonProxy.INSTANCE.registerPartBarrelClient(() -> ((MutableObject)bet).getValue(), partContext.get(MaterialProperty.MEAN_RGB));
        });
        if (maybeOverriddenPath != null) {
            template = template.withCustomPath(maybeOverriddenPath);
        }
        return template;
    }
}

