/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.config.MIServerConfig;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class RecipeConversions {
    public static RecipeHolder<MachineRecipe> ofSmelting(RecipeHolder<SmeltingRecipe> holder, MachineRecipeType type, RegistryAccess registryAccess) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)holder.id().getNamespace(), (String)("/" + holder.id().getPath() + "_exported_mi_furnace"));
        SmeltingRecipe smeltingRecipe = (SmeltingRecipe)holder.value();
        Ingredient ingredient = (Ingredient)smeltingRecipe.getIngredients().get(0);
        MachineRecipe recipe = new MachineRecipe(type);
        recipe.eu = 2;
        recipe.duration = smeltingRecipe.getCookingTime();
        recipe.itemInputs = Collections.singletonList(new MachineRecipe.ItemInput(ingredient, 1, 1.0f));
        recipe.fluidInputs = Collections.emptyList();
        recipe.itemOutputs = Collections.singletonList(new MachineRecipe.ItemOutput(ItemVariant.of(smeltingRecipe.getResultItem((HolderLookup.Provider)registryAccess)), 1, 1.0f));
        recipe.fluidOutputs = Collections.emptyList();
        return new RecipeHolder(id, (Recipe)recipe);
    }

    @Nullable
    public static RecipeHolder<MachineRecipe> ofStonecutting(RecipeHolder<StonecutterRecipe> holder, MachineRecipeType type, RegistryAccess registryAccess) {
        if (!MIServerConfig.INSTANCE.stonecutterToCuttingMachine.getAsBoolean()) {
            return null;
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)holder.id().getNamespace(), (String)("/" + holder.id().getPath() + "_exported_mi_cutting_machine"));
        StonecutterRecipe stonecuttingRecipe = (StonecutterRecipe)holder.value();
        MachineRecipe recipe = new MachineRecipe(type);
        recipe.eu = 2;
        recipe.duration = 200;
        recipe.itemInputs = Collections.singletonList(new MachineRecipe.ItemInput((Ingredient)stonecuttingRecipe.getIngredients().get(0), 1, 1.0f));
        recipe.fluidInputs = Collections.singletonList(new MachineRecipe.FluidInput(FluidIngredient.of((Fluid[])new Fluid[]{MIFluids.LUBRICANT.asFluid()}), 1L, 1.0f));
        recipe.itemOutputs = Collections.singletonList(new MachineRecipe.ItemOutput(ItemVariant.of(stonecuttingRecipe.getResultItem(null)), stonecuttingRecipe.getResultItem((HolderLookup.Provider)registryAccess).getCount(), 1.0f));
        recipe.fluidOutputs = Collections.emptyList();
        return new RecipeHolder(id, (Recipe)recipe);
    }

    @Nullable
    public static RecipeHolder<MachineRecipe> ofCompostable(ItemLike compostable) {
        if (!MIServerConfig.INSTANCE.compostableToPlantOil.getAsBoolean()) {
            return null;
        }
        if (compostable == null || compostable.asItem() == null) {
            return null;
        }
        float probability = ComposterBlock.COMPOSTABLES.getOrDefault((Object)compostable.asItem(), 0.0f);
        if (probability > 0.0f) {
            ResourceLocation id = MI.id("/" + BuiltInRegistries.ITEM.getKey((Object)compostable.asItem()).getPath() + "_to_plant_oil");
            MachineRecipe plantOil = new MachineRecipe(MIMachineRecipeTypes.CENTRIFUGE);
            plantOil.eu = 8;
            plantOil.duration = 200;
            plantOil.itemInputs = List.of(new MachineRecipe.ItemInput(Ingredient.of((ItemLike[])new ItemLike[]{compostable}), 1, 1.0f));
            plantOil.fluidInputs = Collections.emptyList();
            plantOil.fluidOutputs = List.of(new MachineRecipe.FluidOutput(MIFluids.PLANT_OIL.asFluid(), (long)(probability * 1000.0f), 1.0f));
            plantOil.itemOutputs = Collections.emptyList();
            return new RecipeHolder(id, (Recipe)plantOil);
        }
        return null;
    }
}

