/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeType
implements RecipeType<MachineRecipe>,
RecipeSerializer<MachineRecipe> {
    private final MapCodec<MachineRecipe> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, MachineRecipe> streamCodec;
    private final Map<Item, List<RecipeHolder<MachineRecipe>>> recipeCache = new HashMap<Item, List<RecipeHolder<MachineRecipe>>>();
    private final List<RecipeHolder<MachineRecipe>> fluidOnlyRecipes = new ArrayList<RecipeHolder<MachineRecipe>>();
    private long lastUpdate = 0L;
    private static final long UPDATE_INTERVAL = 20000L;
    private final ResourceLocation id;
    private boolean allowItemInput = false;
    private boolean allowFluidInput = false;
    private boolean allowItemOutput = false;
    private boolean allowFluidOutput = false;

    public MachineRecipeType(ResourceLocation id) {
        this.id = id;
        MapCodec<MachineRecipe> baseCodec = MachineRecipe.codec(this);
        this.codec = MapCodec.of(baseCodec, (MapDecoder)baseCodec.flatMap(machineRecipe -> {
            try {
                this.validateRecipe((MachineRecipe)machineRecipe);
                return DataResult.success((Object)machineRecipe);
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(() -> "Failed to read machine recipe:" + e.getMessage());
            }
        }), () -> "MachineRecipe[" + String.valueOf(baseCodec) + "]");
        this.streamCodec = MachineRecipe.streamCodec(this);
    }

    protected Collection<RecipeHolder<MachineRecipe>> getManagerRecipes(Level level) {
        return level.getRecipeManager().getAllRecipesFor((RecipeType)this);
    }

    public Collection<RecipeHolder<MachineRecipe>> getRecipesWithoutCache(Level level) {
        return this.getManagerRecipes(level);
    }

    public Collection<RecipeHolder<MachineRecipe>> getRecipesWithCache(ServerLevel level) {
        return this.getManagerRecipes((Level)level);
    }

    @Nullable
    public RecipeHolder<MachineRecipe> getRecipe(ServerLevel world, ResourceLocation id) {
        return this.getRecipesWithCache(world).stream().filter(r -> r.id().equals((Object)id)).findFirst().orElse(null);
    }

    private void updateRecipeCache(ServerLevel world) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate <= 20000L) {
            return;
        }
        this.lastUpdate = time;
        this.recipeCache.clear();
        this.fluidOnlyRecipes.clear();
        for (RecipeHolder<MachineRecipe> recipe : this.getRecipesWithCache(world)) {
            if (((MachineRecipe)recipe.value()).itemInputs.size() == 0) {
                if (((MachineRecipe)recipe.value()).fluidInputs.size() <= 0) continue;
                this.fluidOnlyRecipes.add(recipe);
                continue;
            }
            for (Item inputItem : ((MachineRecipe)recipe.value()).itemInputs.get(0).getInputItems()) {
                this.recipeCache.putIfAbsent(inputItem, new ArrayList());
                this.recipeCache.get(inputItem).add(recipe);
            }
        }
    }

    public Collection<RecipeHolder<MachineRecipe>> getMatchingRecipes(ServerLevel world, Item input) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableCollection(this.recipeCache.getOrDefault(input, Collections.emptyList()));
    }

    public Collection<RecipeHolder<MachineRecipe>> getFluidOnlyRecipes(ServerLevel world) {
        this.updateRecipeCache(world);
        return Collections.unmodifiableList(this.fluidOnlyRecipes);
    }

    public MachineRecipeType withItemInputs() {
        this.allowItemInput = true;
        return this;
    }

    public MachineRecipeType withFluidInputs() {
        this.allowFluidInput = true;
        return this;
    }

    public MachineRecipeType withItemOutputs() {
        this.allowItemOutput = true;
        return this;
    }

    public MachineRecipeType withFluidOutputs() {
        this.allowFluidOutput = true;
        return this;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getPath() {
        return this.id.getPath();
    }

    private void validateRecipe(MachineRecipe recipe) {
        if (!this.allowItemInput && recipe.itemInputs.size() > 0) {
            throw new IllegalArgumentException("Item inputs are not allowed.");
        }
        if (!this.allowFluidInput && recipe.fluidInputs.size() > 0) {
            throw new IllegalArgumentException("Fluid inputs are not allowed.");
        }
        if (!this.allowItemOutput && recipe.itemOutputs.size() > 0) {
            throw new IllegalArgumentException("Item outputs are not allowed.");
        }
        if (!this.allowFluidOutput && recipe.fluidOutputs.size() > 0) {
            throw new IllegalArgumentException("Fluid outputs are not allowed.");
        }
        if (recipe.itemInputs.size() + recipe.fluidInputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item input.");
        }
        if (recipe.itemOutputs.size() + recipe.fluidOutputs.size() == 0) {
            throw new IllegalArgumentException("Must have at least one fluid or item output.");
        }
    }

    public MapCodec<MachineRecipe> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, MachineRecipe> streamCodec() {
        return this.streamCodec;
    }
}

