/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public enum HatchType {
    ITEM_INPUT(0, MIText.ItemInputHatch),
    ITEM_OUTPUT(1, MIText.ItemOutputHatch),
    FLUID_INPUT(2, MIText.FluidInputHatch),
    FLUID_OUTPUT(3, MIText.FluidOutputHatch),
    ENERGY_INPUT(4, MIText.EnergyInputHatch),
    ENERGY_OUTPUT(5, MIText.EnergyOutputHatch),
    NUCLEAR_ITEM(6, "nuclear_item_hatch"),
    NUCLEAR_FLUID(7, "nuclear_fluid_hatch"),
    LARGE_TANK(8, "large_tank_hatch");

    private final int id;
    private final Either<MIText, ResourceLocation> descriptionOrBlockId;

    private HatchType(int id, MIText description) {
        this.id = id;
        this.descriptionOrBlockId = Either.left((Object)((Object)description));
    }

    private HatchType(int id, String blockId) {
        this.id = id;
        this.descriptionOrBlockId = Either.right((Object)MI.id(blockId));
    }

    public int getId() {
        return this.id;
    }

    public MutableComponent description() {
        return (MutableComponent)this.descriptionOrBlockId.map(MIText::text, id -> ((Block)BuiltInRegistries.BLOCK.get(id)).getName());
    }
}

