/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class LubricantHelper {
    public static final int mbPerTick = 25;

    public static ItemInteractionResult onUse(CrafterComponent crafter, Player player, InteractionHand hand) {
        if (crafter.hasActiveRecipe()) {
            int tick = crafter.getEfficiencyTicks();
            int maxTick = crafter.getMaxEfficiencyTicks();
            int rem = maxTick - tick;
            if (rem > 0) {
                int maxAllowedLubricant = rem * 25;
                FluidTank interactionTank = new FluidTank(maxAllowedLubricant, stack -> stack.getFluid() == MIFluids.LUBRICANT.asFluid());
                FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)player.getItemInHand(hand), (IFluidHandler)interactionTank, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (int)maxAllowedLubricant, (Player)player, (boolean)true);
                if (result.isSuccess() && interactionTank.getFluidAmount() >= 25) {
                    crafter.increaseEfficiencyTicks(interactionTank.getFluidAmount() / 25);
                    player.setItemInHand(hand, result.getResult());
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

