/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.pipes.impl.CamouflageHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.item.SavedItemPipeConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ConfigCardItem
extends Item {
    public static final String TAG_SAVEDCONFIG = "savedconfig";

    public ConfigCardItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext c) {
        Player player = c.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            PipeBlock pipe;
            ItemInteractionResult pipeUseResult;
            BlockState hitState = c.getLevel().getBlockState(c.getClickedPos());
            InteractionHand usedHand = c.getHand();
            Block block = hitState.getBlock();
            if (block instanceof PipeBlock && (pipeUseResult = (pipe = (PipeBlock)block).useItemOn(c.getItemInHand(), c.getLevel().getBlockState(c.getClickedPos()), c.getLevel(), c.getClickedPos(), c.getPlayer(), c.getHand(), new BlockHitResult(c.getClickLocation(), c.getClickedFace(), c.getClickedPos(), c.isInside()))).consumesAction()) {
                return pipeUseResult.result();
            }
            if (ConfigCardItem.setCamouflage(player, usedHand, hitState)) {
                return InteractionResult.sidedSuccess((boolean)c.getLevel().isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public static boolean setCamouflage(Player player, InteractionHand usedHand, BlockState hitState) {
        if (CamouflageHelper.isReasonableCamouflage(hitState)) {
            player.getItemInHand(usedHand).remove(MIComponents.SAVED_CONFIG);
            player.getItemInHand(usedHand).set(MIComponents.CAMOUFLAGE, (Object)hitState);
            player.displayClientMessage((Component)MITooltips.line(MIText.ConfigCardSetCamouflage, Style.EMPTY).arg(hitState, MITooltips.BLOCK_STATE_PARSER).build(), true);
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            player.getItemInHand(usedHand).remove(MIComponents.SAVED_CONFIG);
            player.getItemInHand(usedHand).remove(MIComponents.CAMOUFLAGE);
            player.displayClientMessage((Component)MIText.ConfigCardCleared.text(), true);
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(usedHand), (boolean)level.isClientSide());
        }
        return super.use(level, player, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        BlockState camouflage;
        SavedItemPipeConfig savedConfig = (SavedItemPipeConfig)stack.get(MIComponents.SAVED_CONFIG);
        if (savedConfig != null) {
            int filterSize = savedConfig.filter().size();
            MutableComponent component = filterSize == 0 ? MIText.ConfigCardConfiguredNoItems.text() : MIText.ConfigCardConfiguredItems.text(Component.literal((String)("" + filterSize)).setStyle(MITooltips.NUMBER_TEXT));
            tooltipComponents.add((Component)component.withStyle(MITooltips.DEFAULT_STYLE));
        }
        if (!(camouflage = ConfigCardItem.readCamouflage(stack)).isAir()) {
            tooltipComponents.add((Component)MITooltips.line(MIText.ConfigCardConfiguredCamouflage, Style.EMPTY).arg(camouflage, MITooltips.BLOCK_STATE_PARSER).build());
        }
    }

    public static BlockState readCamouflage(ItemStack stack) {
        return (BlockState)stack.getOrDefault(MIComponents.CAMOUFLAGE, (Object)Blocks.AIR.defaultBlockState());
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        SavedItemPipeConfig savedConfig = (SavedItemPipeConfig)stack.get(MIComponents.SAVED_CONFIG);
        if (savedConfig != null) {
            List<ItemStack> stacks = savedConfig.filter();
            return stacks.isEmpty() ? Optional.empty() : Optional.of(new TooltipData(stacks));
        }
        BlockState camouflage = ConfigCardItem.readCamouflage(stack);
        if (!camouflage.isAir()) {
            return Optional.of(new TooltipData(List.of(new ItemStack((ItemLike)camouflage.getBlock()))));
        }
        return Optional.empty();
    }

    public record TooltipData(List<ItemStack> filter) implements TooltipComponent
    {
    }
}

