/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.guidebook;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.TextTooltip;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import guideme.scene.GuidebookScene;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import guideme.scene.element.SceneElementTagCompiler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class MultiblockShapeCompiler
implements SceneElementTagCompiler {
    public Set<String> getTagNames() {
        return Set.of("MultiblockShape");
    }

    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        MachineBlock machineBlock;
        Pair controller = MdxAttrs.getRequiredBlockAndId((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"controller");
        if (controller == null) {
            return;
        }
        Object object = controller.getRight();
        if (!(object instanceof MachineBlock) || !((object = (machineBlock = (MachineBlock)object).getBlockEntityInstance()) instanceof MultiblockMachineBlockEntity)) {
            errorSink.appendError(compiler, "Block is not a multiblock controller: " + String.valueOf(controller.getLeft()), (UnistNode)el);
            return;
        }
        MultiblockMachineBlockEntity multi = (MultiblockMachineBlockEntity)object;
        boolean useBigShape = MdxAttrs.getBoolean((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"useBigShape", (boolean)false);
        ShapeTemplate shape = useBigShape ? multi.getBigShape() : multi.getActiveShape();
        BlockPos controllerPos = MdxAttrs.getPos((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el);
        scene.getLevel().setBlockAndUpdate(controllerPos, ((Block)controller.getRight()).defaultBlockState());
        for (Map.Entry<BlockPos, SimpleMember> entry : shape.simpleMembers.entrySet()) {
            scene.getLevel().setBlockAndUpdate(entry.getKey().offset((Vec3i)controllerPos), entry.getValue().getPreviewState());
        }
        for (Map.Entry<BlockPos, Object> entry : shape.hatchFlags.entrySet()) {
            Vec3 minCorner = Vec3.atLowerCornerOf((Vec3i)entry.getKey().offset((Vec3i)controllerPos));
            InWorldBoxAnnotation annotation = new InWorldBoxAnnotation(minCorner.toVector3f(), minCorner.add(1.0, 1.0, 1.0).toVector3f(), (ColorValue)SymbolicColor.GREEN);
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            SimpleMember member = shape.simpleMembers.get(entry.getKey());
            tooltipLines.add(member.getPreviewState().getBlock().getName());
            tooltipLines.add(MIText.AcceptsHatches.text());
            HatchFlags flags = (HatchFlags)entry.getValue();
            for (HatchType type : HatchType.values()) {
                if (!flags.allows(type)) continue;
                tooltipLines.add(Component.literal((String)"- ").append((Component)type.description()));
            }
            annotation.setTooltip((GuideTooltip)new TextTooltip(tooltipLines));
            scene.addAnnotation((SceneAnnotation)annotation);
        }
    }
}

