/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.texture;

import aztech.modern_industrialization.resource.FastPathPackResources;
import aztech.modern_industrialization.textures.MITextures;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public record TexturesProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper, boolean runtimeDatagen) implements DataProvider
{
    private static PackLocationInfo makePackInfo(String name) {
        return new PackLocationInfo(name, (Component)Component.literal((String)name), PackSource.BUILT_IN, Optional.empty());
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<Object> packs = new ArrayList<Object>();
        packs.add(new VanillaPackResourcesBuilder().exposeNamespace(new String[]{"minecraft"}).pushJarResources().build(TexturesProvider.makePackInfo("vanilla-textures")));
        if (this.runtimeDatagen) {
            packs.add(new PathPackResources(TexturesProvider.makePackInfo("mi:runtimedatagen"), ModList.get().getModFileById("modern_industrialization").getFile().getSecureJar().getRootPath()));
            Path extra = FMLPaths.GAMEDIR.get().resolve("modern_industrialization").resolve("extra_datagen_resources");
            packs.add((Object)new FastPathPackResources(TexturesProvider.makePackInfo("extra"), extra));
        } else {
            Path nonGeneratedResources = this.packOutput.getOutputFolder().resolve("../../main/resources");
            packs.add((Object)new FastPathPackResources(TexturesProvider.makePackInfo("nonGen"), nonGeneratedResources));
        }
        ArrayList jsonSaveFutures = new ArrayList();
        MultiPackResourceManager fallbackProvider = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, packs);
        return ((CompletableFuture)this.generateTextures(cache, (ResourceProvider)fallbackProvider, jsonSaveFutures::add).whenComplete((result, throwable) -> fallbackProvider.close())).thenRunAsync(() -> CompletableFuture.allOf((CompletableFuture[])jsonSaveFutures.toArray(CompletableFuture[]::new)), Util.backgroundExecutor());
    }

    private CompletableFuture<?> generateTextures(CachedOutput cache, ResourceProvider fallbackResourceProvider, Consumer<CompletableFuture<?>> futureList) {
        Path generatedResources = this.packOutput.getOutputFolder();
        List<FastPathPackResources> generatedPack = List.of(new FastPathPackResources(TexturesProvider.makePackInfo("gen"), generatedResources));
        MultiPackResourceManager outputPack = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, generatedPack);
        return MITextures.offerTextures((image, textureId) -> this.writeTexture(cache, (NativeImage)image, (String)textureId), (json, path) -> futureList.accept(this.customJsonSave(cache, (JsonElement)json, (String)path)), resourceLocation -> {
            Optional generated = outputPack.getResource(resourceLocation);
            if (generated.isPresent()) {
                return generated;
            }
            return fallbackResourceProvider.getResource(resourceLocation);
        }, this.existingFileHelper).whenComplete((result, throwable) -> outputPack.close());
    }

    private void writeTexture(CachedOutput cache, NativeImage image, String textureId) {
        try {
            Path path = this.packOutput.getOutputFolder().resolve("assets").resolve(textureId.replace(':', '/'));
            cache.writeIfNeeded(path, image.asByteArray(), Hashing.sha1().hashBytes(image.asByteArray()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write texture " + textureId, ex);
        }
    }

    private CompletableFuture<?> customJsonSave(CachedOutput cache, JsonElement jsonElement, String path) {
        Path pathFormatted = this.packOutput.getOutputFolder().resolve("assets").resolve(path.replace(':', '/'));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonElement, (Path)pathFormatted);
    }

    public String getName() {
        return "Textures";
    }
}

