/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import aztech.modern_industrialization.recipe.json.ShapelessRecipeBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class UpgradeProvider
extends MIRecipesProvider {
    private static final String[] STEEL_UPGRADE_MACHINES = new String[]{"compressor", "macerator", "cutting_machine", "water_pump", "mixer", "furnace", "boiler"};
    private static final Set<String> STEEL_NO_UNPACKER = Set.of("furnace", "boiler");
    private static final List<String> QUANTUM_ITEMS = List.of("helmet", "chestplate", "leggings", "boots", "sword");

    public UpgradeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public void buildRecipes(RecipeOutput consumer) {
        this.buildSteelUpgrades(consumer);
        this.buildQuantumUpgrades(consumer);
    }

    private void buildSteelUpgrades(RecipeOutput consumer) {
        Item upgrade = (Item)BuiltInRegistries.ITEM.get(MI.id("steel_upgrade"));
        for (String machine : STEEL_UPGRADE_MACHINES) {
            Item bronze = (Item)BuiltInRegistries.ITEM.get(MI.id("bronze_" + machine));
            Item steel = (Item)BuiltInRegistries.ITEM.get(MI.id("steel_" + machine));
            ShapelessRecipeBuilder recipe = ShapelessRecipeBuilder.shapeless((ItemLike)steel).requires((ItemLike)bronze).requires((ItemLike)upgrade);
            recipe.offerTo(consumer, "upgrade/craft/steel/" + machine);
            MachineRecipeBuilder recipePacker = (MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.PACKER, 2, 100).addItemInput((ItemLike)bronze, 1)).addItemInput((ItemLike)upgrade, 1)).addItemOutput(steel, 1);
            recipePacker.offerTo(consumer, "upgrade/packer/steel/" + machine);
            if (STEEL_NO_UNPACKER.contains(machine)) continue;
            MachineRecipeBuilder recipeUnpacker = (MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.UNPACKER, 2, 100).addItemOutput(bronze, 1)).addItemOutput(upgrade, 1)).addItemInput((ItemLike)steel, 1);
            recipeUnpacker.offerTo(consumer, "upgrade/unpacker/steel/" + machine);
        }
    }

    private void buildQuantumUpgrades(RecipeOutput consumer) {
        for (String itemType : QUANTUM_ITEMS) {
            MachineRecipeBuilder packerRecipe = (MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.PACKER, 1000000, 200).addItemInput("minecraft:netherite_" + itemType, 1)).addItemInput("modern_industrialization:quantum_upgrade", 1)).addItemOutput("modern_industrialization:quantum_" + itemType, 1);
            packerRecipe.offerTo(consumer, "upgrade/packer/quantum/" + itemType);
        }
    }
}

