/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.machines.recipe.condition.AdjacentBlockProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.BiomeProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.CustomProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.DimensionProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.util.Either;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public interface ProcessConditionHelper {
    public ProcessConditionHelper processCondition(MachineProcessCondition var1);

    default public ProcessConditionHelper dimension(ResourceLocation dimension) {
        return this.processCondition(new DimensionProcessCondition((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension)));
    }

    default public ProcessConditionHelper adjacentBlock(Block block, String relativePosition) {
        return this.processCondition(new AdjacentBlockProcessCondition(block, relativePosition));
    }

    default public ProcessConditionHelper biome(ResourceLocation biome) {
        return this.processCondition(new BiomeProcessCondition((Either<ResourceKey<Biome>, TagKey<Biome>>)Either.left((Object)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)biome))));
    }

    default public ProcessConditionHelper biomeTag(ResourceLocation tag) {
        return this.processCondition(new BiomeProcessCondition((Either<ResourceKey<Biome>, TagKey<Biome>>)Either.right((Object)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tag))));
    }

    default public ProcessConditionHelper customCondition(String id) {
        return this.processCondition(new CustomProcessCondition(id));
    }
}

