/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel.client;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Matrix4f;

public record BarrelTooltipComponent(BarrelTooltipData data) implements ClientTooltipComponent
{
    public int getHeight() {
        return 30;
    }

    public int getWidth(Font textRenderer) {
        return Math.max(textRenderer.width((FormattedText)this.data.variant().toStack().getHoverName()), 20 + textRenderer.width((FormattedText)this.getItemNumber()));
    }

    public void renderText(Font textRenderer, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource immediate) {
        Style style = MITooltips.DEFAULT_STYLE;
        textRenderer.drawInBatch((Component)this.data.variant().toStack().getHoverName().copy().setStyle(style), (float)x, (float)y, -1, true, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        textRenderer.drawInBatch(this.getItemNumber(), (float)(x + 20), (float)(y + 15), -1, true, matrix4f, (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public Component getItemNumber() {
        MutableComponent itemNumber;
        long amount = this.data.amount();
        long capacity = this.data.capacity();
        Style style = TextHelper.YELLOW;
        if (this.data.creative()) {
            itemNumber = Component.literal((String)"\u221e / \u221e").setStyle(style);
        } else {
            String capacityStr;
            String amountStr;
            Component percent = MITooltips.INVERTED_RATIO_PERCENTAGE_PARSER.parse((double)amount / (double)capacity);
            if (Screen.hasShiftDown()) {
                amountStr = "" + amount;
                capacityStr = "" + capacity;
            } else {
                TextHelper.Amount amountText = TextHelper.getAmount(amount);
                TextHelper.Amount capacityText = TextHelper.getAmount(capacity);
                amountStr = amountText.digit() + amountText.unit();
                capacityStr = capacityText.digit() + capacityText.unit();
            }
            itemNumber = MIText.BarrelStorageComponent.text(amountStr, capacityStr, percent).setStyle(style);
        }
        return itemNumber;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        RenderHelper.renderAndDecorateItem(guiGraphics, font, this.data.variant().toStack(), x, y + 10);
    }
}

