/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotFluidHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotItemHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;

public class MICapabilities {
    private static final List<Consumer<RegisterCapabilitiesEvent>> processors = new ArrayList<Consumer<RegisterCapabilitiesEvent>>();

    public static void init(RegisterCapabilitiesEvent event) {
        for (FluidDefinition fluid : MIFluids.FLUID_DEFINITIONS.values()) {
            event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{fluid.getBucket()});
        }
        processors.forEach(c -> c.accept(event));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, MIRegistries.CREATIVE_BARREL_BE.get(), (be, side) -> new SlotItemHandler((SingleSlotStorage<ItemVariant>)be));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, MIRegistries.CREATIVE_TANK_BE.get(), (be, side) -> new SlotFluidHandler((SingleSlotStorage<FluidVariant>)be));
        event.registerBlockEntity(EnergyApi.SIDED, MIRegistries.CREATIVE_STORAGE_UNIT_BE.get(), (be, side) -> EnergyApi.CREATIVE);
        Block[] allBlocks = (Block[])StreamSupport.stream(BuiltInRegistries.BLOCK.spliterator(), false).toArray(Block[]::new);
        Item[] allItems = (Item[])StreamSupport.stream(BuiltInRegistries.ITEM.spliterator(), false).toArray(Item[]::new);
        EnergyApi.init(event, allBlocks, allItems);
    }

    public static void onEvent(Consumer<RegisterCapabilitiesEvent> consumer) {
        processors.add(consumer);
    }
}

