/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.util;

import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemVariantImpl
implements ItemVariant {
    private static final Map<Item, ItemVariant> noTagCache = new ConcurrentHashMap<Item, ItemVariant>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/item");
    private final ItemStack stack;
    private final int hashCode;

    public static ItemVariant of(Item item) {
        Objects.requireNonNull(item, "Item may not be null.");
        return noTagCache.computeIfAbsent(item, i -> new ItemVariantImpl(new ItemStack((ItemLike)i)));
    }

    public static ItemVariant of(ItemStack stack) {
        Objects.requireNonNull(stack);
        if (stack.isComponentsPatchEmpty() || stack.isEmpty()) {
            return ItemVariantImpl.of(stack.getItem());
        }
        return new ItemVariantImpl(stack);
    }

    private ItemVariantImpl(ItemStack stack) {
        this.stack = stack.copyWithCount(1);
        this.hashCode = ItemStack.hashItemAndComponents((ItemStack)stack);
    }

    @Override
    public Item getObject() {
        return this.stack.getItem();
    }

    @Override
    public DataComponentPatch getComponentsPatch() {
        return this.stack.getComponentsPatch();
    }

    @Override
    public boolean matches(ItemStack stack) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack);
    }

    @Override
    public ItemStack toStack(int count) {
        return this.stack.copyWithCount(count);
    }

    @Override
    public int getMaxStackSize() {
        return this.stack.getMaxStackSize();
    }

    @Override
    public boolean isBlank() {
        return this.stack.isEmpty();
    }

    public String toString() {
        return "ItemVariant{stack=" + String.valueOf(this.stack) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariantImpl itemVariant = (ItemVariantImpl)o;
        return this.hashCode == itemVariant.hashCode && this.matches(itemVariant.stack);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

