/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test;

import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.init.MdItems;
import dev.technici4n.moderndynamics.test.MdGameTest;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;

public class ItemTransferTest {
    @MdGameTest
    public void testHopperInsertingDamagedItem(MdGameTestHelper helper) {
        BlockPos targetChest = new BlockPos(0, 1, 0);
        helper.setBlock(targetChest, Blocks.CHEST.defaultBlockState());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(targetChest);
        BlockPos pipe = targetChest.east();
        helper.pipe(pipe, MdBlocks.ITEM_PIPE);
        BlockPos hopper = pipe.above();
        helper.setBlock(hopper, Blocks.HOPPER.defaultBlockState());
        ItemStack damagedItem = Items.DIAMOND_PICKAXE.getDefaultInstance();
        damagedItem.setDamageValue(500);
        ((HopperBlockEntity)helper.getBlockEntity(hopper)).setItem(0, damagedItem.copy());
        helper.startSequence().thenWaitUntil(() -> {
            if (chest.getItem(0).isEmpty()) {
                helper.fail("Expected item in chest", targetChest);
            }
            if (!ItemStack.matches((ItemStack)damagedItem, (ItemStack)chest.getItem(0))) {
                helper.fail("Wrong item in chest", targetChest);
            }
        }).thenSucceed();
    }

    @MdGameTest
    public void testExtractorLimitIsForEntireInventory(MdGameTestHelper helper) {
        BlockPos sourceChest = new BlockPos(0, 1, 0);
        helper.setBlock(sourceChest, Blocks.CHEST.defaultBlockState());
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(sourceChest);
        helper.pipe(new BlockPos(1, 1, 0), MdBlocks.ITEM_PIPE).attachment(Direction.WEST, MdItems.EXTRACTOR).configureItemIo(Direction.WEST, io -> io.setMaxItemsExtracted(2));
        BlockPos targetChest = new BlockPos(2, 1, 0);
        helper.setBlock(targetChest, Blocks.CHEST.defaultBlockState());
        for (int i = 0; i < 9; ++i) {
            chest.setItem(i, new ItemStack((ItemLike)Items.DIAMOND, 7));
        }
        helper.startSequence().thenIdle(1).thenExecute(() -> {
            if (!ItemStack.matches((ItemStack)new ItemStack((ItemLike)Items.DIAMOND, 5), (ItemStack)chest.getItem(0))) {
                helper.fail("Expected 6 diamonds in slot 0", targetChest);
            }
            for (int i = 1; i < 9; ++i) {
                if (ItemStack.matches((ItemStack)new ItemStack((ItemLike)Items.DIAMOND, 7), (ItemStack)chest.getItem(i))) continue;
                helper.fail("Expected 16 diamonds in slot " + i, targetChest);
            }
        }).thenSucceed();
    }
}

