/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import com.google.common.collect.Lists;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.AttachedInhibitor;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.item.ItemCache;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class ItemPathCache {
    private final Map<SidedNode, List<ItemPath>> cache = new HashMap<SidedNode, List<ItemPath>>();

    public List<ItemPath> getPaths(NetworkNode<ItemHost, ItemCache> startingPoint, Direction startingSide) {
        return this.cache.computeIfAbsent(new SidedNode(startingPoint, startingSide), ItemPathCache::computePaths);
    }

    public void invalidate() {
        this.cache.clear();
    }

    private static List<ItemPath> computePaths(SidedNode startingPoint) {
        PriorityQueue<PqNode> pq = new PriorityQueue<PqNode>(Comparator.comparingLong(PqNode::distance));
        Reference2LongOpenHashMap distance = new Reference2LongOpenHashMap();
        IdentityHashMap prevDirection = new IdentityHashMap();
        IdentityHashMap prevNode = new IdentityHashMap();
        PriorityQueue<PqSidedNode> targets = new PriorityQueue<PqSidedNode>(Comparator.comparingLong(PqSidedNode::distance));
        pq.add(new PqNode(startingPoint.node, 0L));
        distance.put(startingPoint.node, 0L);
        while (!pq.isEmpty()) {
            PqNode currentPqNode = pq.poll();
            long currentDistance = currentPqNode.distance;
            NetworkNode<ItemHost, ItemCache> currentNode = currentPqNode.node;
            if (currentDistance != distance.getLong(currentNode)) continue;
            for (Direction direction : currentNode.getHost().getInventoryConnections()) {
                AttachedAttachment attachment = currentNode.getHost().getAttachment(direction);
                if (attachment != null && !attachment.allowsItemConnection()) continue;
                long edgeWeight = 1L;
                if (currentNode.getHost().getAttachment(direction) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                targets.add(new PqSidedNode(new SidedNode(currentNode, direction), currentDistance + edgeWeight));
            }
            for (NetworkNode.Connection connection : currentNode.getConnections()) {
                long edgeWeight = 1L;
                if (currentNode.getHost().getAttachment(connection.direction()) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                if (((ItemHost)connection.target().getHost()).getAttachment(connection.direction().getOpposite()) instanceof AttachedInhibitor) {
                    edgeWeight += 1000L;
                }
                long newDistance = currentDistance + edgeWeight;
                if (distance.getOrDefault(connection.target(), Long.MAX_VALUE) <= newDistance) continue;
                distance.put(connection.target(), newDistance);
                pq.add(new PqNode(connection.target(), newDistance));
                prevDirection.put(connection.target(), connection.direction());
                prevNode.put(connection.target(), currentNode);
            }
        }
        ArrayList<ItemPath> computedPaths = new ArrayList<ItemPath>(targets.size());
        for (PqSidedNode pqTarget : targets) {
            SidedNode target = pqTarget.sidedNode;
            Direction side = target.side;
            if (target.node == startingPoint.node && side == startingPoint.side.getOpposite()) continue;
            BlockPos blockPos = target.node.getHost().getPipe().getBlockPos().relative(side);
            ArrayList<Direction> reversedPath = new ArrayList<Direction>();
            NetworkNode current = target.node;
            Direction currentDir = side;
            while (current != null) {
                reversedPath.add(currentDir);
                currentDir = (Direction)prevDirection.get(current);
                current = (NetworkNode)prevNode.get(current);
            }
            reversedPath.add(startingPoint.side);
            Direction[] path = (Direction[])Lists.reverse(reversedPath).toArray(Direction[]::new);
            BlockPos startPos = startingPoint.node.getHost().getPipe().getBlockPos().relative(startingPoint.side.getOpposite());
            computedPaths.add(new ItemPath(startPos, blockPos, path));
        }
        return Collections.unmodifiableList(computedPaths);
    }

    private record SidedNode(NetworkNode<ItemHost, ItemCache> node, Direction side) {
    }

    private record PqNode(NetworkNode<ItemHost, ItemCache> node, long distance) {
    }

    private record PqSidedNode(SidedNode sidedNode, long distance) {
    }
}

