/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ServerLevel;

public abstract class NetworkCache<H extends NodeHost, C extends NetworkCache<H, C>> {
    public final ServerLevel level;
    protected final List<NetworkNode<H, C>> nodes;
    private boolean combined = false;
    private final Set<NodeHost> hostsToUpdate = Collections.newSetFromMap(new IdentityHashMap());

    protected NetworkCache(ServerLevel level, List<NetworkNode<H, C>> nodes) {
        this.level = level;
        this.nodes = nodes;
        for (NetworkNode<H, C> node : nodes) {
            if (!((NodeHost)node.getHost()).needsUpdate()) continue;
            this.hostsToUpdate.add((NodeHost)node.getHost());
        }
    }

    protected abstract void doTick();

    protected final void tick() {
        Iterator<NodeHost> it = this.hostsToUpdate.iterator();
        while (it.hasNext()) {
            NodeHost host = it.next();
            if (!host.isTicking() || !host.needsUpdate()) continue;
            host.update();
            it.remove();
        }
        try {
            this.doTick();
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.forThrowable((Throwable)t, (String)"Ticking pipe network");
            report.addCategory("Network details").setDetail("Level", (Object)this.level.dimension().location()).setDetail("Number of nodes", (Object)this.nodes.size());
            if (this.nodes.size() > 0) {
                CrashReportCategory nodeDetails = report.addCategory("Details of first node in the network");
                ((NodeHost)this.nodes.get((int)0).getHost()).pipe.fillCrashReportCategory(nodeDetails);
            }
            throw new ReportedException(report);
        }
    }

    public final void scheduleHostUpdate(NodeHost host) {
        this.hostsToUpdate.add(host);
    }

    protected void doCombine() {
    }

    protected void doSeparate() {
    }

    public final void combine() {
        if (!this.combined) {
            this.combined = true;
            this.doCombine();
        }
    }

    public final void separate() {
        if (this.combined) {
            this.combined = false;
            this.doSeparate();
        }
    }

    public void appendDebugInfo(StringBuilder out) {
        out.append("==== Cache: ").append(this.getClass().getSimpleName()).append(" ====\n");
        out.append("Combined = ").append(this.combined).append('\n');
        out.append("Number of nodes = ").append(this.nodes.size()).append('\n');
    }

    public static interface Factory<H extends NodeHost, C extends NetworkCache<H, C>> {
        public C build(ServerLevel var1, List<NetworkNode<H, C>> var2);
    }
}

