/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.init;

import com.google.common.base.Preconditions;
import dev.technici4n.moderndynamics.MdBlock;
import dev.technici4n.moderndynamics.MdBlockEntity;
import dev.technici4n.moderndynamics.compat.mi.MIProxy;
import dev.technici4n.moderndynamics.extender.MachineExtenderBlockEntity;
import dev.technici4n.moderndynamics.init.MdBlocks;
import dev.technici4n.moderndynamics.network.energy.EnergyPipeTier;
import dev.technici4n.moderndynamics.network.mienergy.MICableTier;
import dev.technici4n.moderndynamics.pipe.EnergyPipeBlockEntity;
import dev.technici4n.moderndynamics.pipe.FluidPipeBlockEntity;
import dev.technici4n.moderndynamics.pipe.ItemPipeBlockEntity;
import dev.technici4n.moderndynamics.pipe.MIEnergyCableBlockEntity;
import dev.technici4n.moderndynamics.pipe.PipeBlock;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.MdId;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public final class MdBlockEntities {
    private static final List<Consumer<RegisterCapabilitiesEvent>> capRegistrations = new ArrayList<Consumer<RegisterCapabilitiesEvent>>();
    public static final BlockEntityType<PipeBlockEntity> ITEM_PIPE = MdBlockEntities.register(ItemPipeBlockEntity::new, MdBlocks.ITEM_PIPE);
    public static final BlockEntityType<PipeBlockEntity> FLUID_PIPE = MdBlockEntities.register(FluidPipeBlockEntity::new, MdBlocks.FLUID_PIPE);
    public static final BlockEntityType<PipeBlockEntity> LV_CABLE = MdBlockEntities.createMIEnergyCable(MdBlocks.LV_CABLE, MICableTier.LV);
    public static final BlockEntityType<PipeBlockEntity> MV_CABLE = MdBlockEntities.createMIEnergyCable(MdBlocks.MV_CABLE, MICableTier.MV);
    public static final BlockEntityType<PipeBlockEntity> HV_CABLE = MdBlockEntities.createMIEnergyCable(MdBlocks.HV_CABLE, MICableTier.HV);
    public static final BlockEntityType<PipeBlockEntity> EV_CABLE = MdBlockEntities.createMIEnergyCable(MdBlocks.EV_CABLE, MICableTier.EV);
    public static final BlockEntityType<PipeBlockEntity> SUPERCONDUCTOR_CABLE = MdBlockEntities.createMIEnergyCable(MdBlocks.SUPERCONDUCTOR_CABLE, MICableTier.SUPERCONDUCTOR);
    public static final BlockEntityType<MachineExtenderBlockEntity> MACHINE_EXTENDER = MdBlockEntities.registerRaw(MachineExtenderBlockEntity::new, MdBlocks.MACHINE_EXTENDER);

    public static void registerCapabilities(RegisterCapabilitiesEvent evt) {
        BlockEntityType<MachineExtenderBlockEntity> type = MACHINE_EXTENDER;
        MachineExtenderBlockEntity.forwardApi(evt, type, Capabilities.ItemHandler.BLOCK);
        MachineExtenderBlockEntity.forwardApi(evt, type, Capabilities.FluidHandler.BLOCK);
        MachineExtenderBlockEntity.forwardApi(evt, type, Capabilities.EnergyStorage.BLOCK);
        MachineExtenderBlockEntity.forwardApi(evt, type, MIProxy.INSTANCE.getLookup());
        for (Consumer<RegisterCapabilitiesEvent> capRegistration : capRegistrations) {
            capRegistration.accept(evt);
        }
    }

    public static void init() {
    }

    private static <T extends MdBlockEntity> BlockEntityType<T> registerRaw(BlockEntityConstructor<T> factory, MdBlock block) {
        BlockEntityType type;
        TypeFactory<T> typeFactory = new TypeFactory<T>(factory);
        typeFactory.type = type = BlockEntityType.Builder.of(typeFactory, (Block[])new Block[]{block}).build(null);
        Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)MdId.of(block.id), (Object)type);
        block.setBlockEntityProvider((BlockEntityType<PipeBlockEntity>)type);
        return type;
    }

    private static <T extends PipeBlockEntity> BlockEntityType<T> register(BlockEntityConstructor<T> factory, PipeBlock block) {
        BlockEntityType type = MdBlockEntities.registerRaw(factory, block);
        capRegistrations.add(evt -> MdBlockEntities.registerLookup(evt, Capabilities.ItemHandler.BLOCK, (BlockEntityType<? extends PipeBlockEntity>)type));
        capRegistrations.add(evt -> MdBlockEntities.registerLookup(evt, Capabilities.FluidHandler.BLOCK, (BlockEntityType<? extends PipeBlockEntity>)type));
        capRegistrations.add(evt -> MdBlockEntities.registerLookup(evt, Capabilities.EnergyStorage.BLOCK, (BlockEntityType<? extends PipeBlockEntity>)type));
        return type;
    }

    private static <A> void registerLookup(RegisterCapabilitiesEvent evt, BlockCapability<A, Direction> lookup, BlockEntityType<? extends PipeBlockEntity> type) {
        Class apiClass = lookup.typeClass();
        evt.registerBlockEntity(lookup, type, (pipe, dir) -> apiClass.cast(pipe.getApiInstance(lookup, (Direction)dir)));
    }

    private static BlockEntityType<PipeBlockEntity> createMIEnergyCable(PipeBlock block, MICableTier tier) {
        return MdBlockEntities.register((type, pos, state) -> new MIEnergyCableBlockEntity(type, pos, state, tier), block);
    }

    private static BlockEntityType<PipeBlockEntity> createEnergyPipe(EnergyPipeTier tier, PipeBlock block) {
        return MdBlockEntities.register((type, pos, state) -> new EnergyPipeBlockEntity(type, tier, pos, state), block);
    }

    static class TypeFactory<T extends MdBlockEntity>
    implements BlockEntityType.BlockEntitySupplier<T> {
        final BlockEntityConstructor<T> constructor;
        BlockEntityType<T> type;

        public TypeFactory(BlockEntityConstructor<T> constructor) {
            this.constructor = constructor;
        }

        public T create(BlockPos blockPos, BlockState blockState) {
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"type has not been registered properly");
            return this.constructor.instantiate(this.type, blockPos, blockState);
        }
    }

    private static interface BlockEntityConstructor<T extends MdBlockEntity> {
        public T instantiate(BlockEntityType<?> var1, BlockPos var2, BlockState var3);
    }
}

