/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.technici4n.moderndynamics.client.screen.AttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.FluidAttachedIoScreen;
import dev.technici4n.moderndynamics.client.screen.ItemAttachedIoScreen;
import dev.technici4n.moderndynamics.gui.menu.ConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.FluidAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.gui.menu.ItemAttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.ItemConfigSlot;
import dev.technici4n.moderndynamics.util.FluidVariant;
import dev.technici4n.moderndynamics.util.ItemVariant;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

class DragDropHandler
implements EmiDragDropHandler<Screen> {
    DragDropHandler() {
    }

    private static Rect2i getSlotBounds(Slot slot, AttachedIoScreen<?> screen) {
        return new Rect2i(slot.x + screen.getLeftPos(), slot.y + screen.getTopPos(), 16, 16);
    }

    public boolean dropStack(Screen gui, EmiIngredient dragged, int mouseX, int mouseY) {
        ConfigSlot slot;
        Object object;
        AttachedIoScreen ioScreen;
        EmiStack ing = (EmiStack)dragged.getEmiStacks().get(0);
        if (gui instanceof ItemAttachedIoScreen) {
            ioScreen = (ItemAttachedIoScreen)gui;
            object = ing.getKey();
            if (object instanceof Item) {
                Item i = (Item)object;
                for (Slot s : ((ItemAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof ItemConfigSlot) || !(slot = (ItemConfigSlot)s).isActive() || !DragDropHandler.getSlotBounds(s, ioScreen).contains(mouseX, mouseY)) continue;
                    ItemVariant iv = ItemVariant.of(ing.getItemStack());
                    ((ItemAttachedIoMenu)ioScreen.getMenu()).setFilter(slot.getConfigIdx(), iv, true);
                    return true;
                }
            }
        }
        if (gui instanceof FluidAttachedIoScreen) {
            ioScreen = (FluidAttachedIoScreen)gui;
            object = ing.getKey();
            if (object instanceof Fluid) {
                Fluid f = (Fluid)object;
                for (Slot s : ((FluidAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof FluidConfigSlot) || !(slot = (FluidConfigSlot)s).isActive() || !DragDropHandler.getSlotBounds(s, ioScreen).contains(mouseX, mouseY)) continue;
                    FluidVariant fv = FluidVariant.of(new FluidStack((Holder)f.builtInRegistryHolder(), 1, ing.getComponentChanges()));
                    ((FluidAttachedIoMenu)ioScreen.getMenu()).setFilter(slot.getConfigIdx(), fv, true);
                    return true;
                }
            }
        }
        return false;
    }

    public void render(Screen gui, EmiIngredient dragged, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        ConfigSlot slot;
        AttachedIoScreen ioScreen;
        EmiStack ing = (EmiStack)dragged.getEmiStacks().get(0);
        ArrayList<Slot> targets = new ArrayList<Slot>();
        if (gui instanceof ItemAttachedIoScreen) {
            ioScreen = (ItemAttachedIoScreen)gui;
            if (ing.getKey() instanceof Item) {
                for (Slot s : ((ItemAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof ItemConfigSlot) || !(slot = (ItemConfigSlot)s).isActive()) continue;
                    targets.add(s);
                }
            }
        }
        if (gui instanceof FluidAttachedIoScreen) {
            ioScreen = (FluidAttachedIoScreen)gui;
            if (ing.getKey() instanceof Fluid) {
                for (Slot s : ((FluidAttachedIoMenu)ioScreen.getMenu()).slots) {
                    if (!(s instanceof FluidConfigSlot) || !(slot = (FluidConfigSlot)s).isActive()) continue;
                    targets.add(s);
                }
            }
        }
        for (Slot s : targets) {
            Rect2i b = DragDropHandler.getSlotBounds(s, (AttachedIoScreen)gui);
            guiGraphics.fill(b.getX(), b.getY(), b.getX() + b.getWidth(), b.getY() + b.getHeight(), -2010989773);
        }
    }
}

