/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.config;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;

public enum MobSelector {
    ALL{

        @Override
        public boolean isValid(LivingEntity entity) {
            return true;
        }
    }
    ,
    TAMED{

        @Override
        public boolean isValid(LivingEntity entity) {
            OwnableEntity tamableAnimal;
            return entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwnerUUID() != null;
        }
    }
    ,
    TAMED_ONLY_OWNER{

        @Override
        public boolean isValid(LivingEntity entity) {
            OwnableEntity tamableAnimal;
            UUID owner = Minecraft.getInstance().player.getUUID();
            return entity instanceof OwnableEntity && owner.equals((tamableAnimal = (OwnableEntity)entity).getOwnerUUID());
        }
    }
    ,
    PLAYER{

        @Override
        public boolean isValid(LivingEntity entity) {
            return entity instanceof Player;
        }
    }
    ,
    MONSTER{

        @Override
        public boolean isValid(LivingEntity entity) {
            return entity instanceof Enemy || !entity.getType().getCategory().isFriendly();
        }
    }
    ,
    BOSS{

        @Override
        public boolean isValid(LivingEntity entity) {
            return CommonAbstractions.INSTANCE.isBossMob(entity.getType());
        }
    }
    ,
    MOUNT{

        @Override
        public boolean isValid(LivingEntity entity) {
            Saddleable saddleable;
            return entity instanceof Saddleable && (saddleable = (Saddleable)entity).isSaddleable();
        }
    };


    public abstract boolean isValid(LivingEntity var1);
}

