/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.client.gui.plaque.TransitionPlaqueRenderer;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.player.Player;

public class HealthPlaqueRenderer
extends TransitionPlaqueRenderer {
    private static final ResourceLocation HEART_VEHICLE_CONTAINER_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"hud/heart/vehicle_container");
    private static final ResourceLocation HEART_VEHICLE_FULL_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"hud/heart/vehicle_full");

    public HealthPlaqueRenderer() {
        super(2011392, 15541005);
    }

    @Override
    public boolean wantsToRender(LivingEntity entity) {
        return this.allowRendering;
    }

    @Override
    public int getValue(LivingEntity entity) {
        return (int)Math.ceil(Math.min(entity.getHealth(), entity.getMaxHealth())) + this.getAbsorptionValue(entity);
    }

    private int getAbsorptionValue(LivingEntity entity) {
        return Mth.ceil((float)entity.getAbsorptionAmount());
    }

    @Override
    public int getMaxValue(LivingEntity entity) {
        return (int)Math.ceil(entity.getMaxHealth()) + this.getAbsorptionValue(entity);
    }

    @Override
    protected void renderIconBackground(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int posX, int posY, LivingEntity entity) {
        this.innerRenderIcon(poseStack, bufferSource, packedLight, posX, posY, 0.01f, HealthPlaqueRenderer.getContainerSprite(entity));
    }

    @Override
    protected ResourceLocation getSprite(LivingEntity entity) {
        return HealthPlaqueRenderer.getFullSprite(entity);
    }

    public static ResourceLocation getContainerSprite(LivingEntity entity) {
        Player player;
        return HealthPlaqueRenderer.isMount(entity) ? HEART_VEHICLE_CONTAINER_SPRITE : Gui.HeartType.CONTAINER.getSprite(entity instanceof Player && (player = (Player)entity).level().getLevelData().isHardcore(), false, false);
    }

    public static ResourceLocation getFullSprite(LivingEntity entity) {
        return HealthPlaqueRenderer.isMount(entity) ? HEART_VEHICLE_FULL_SPRITE : HealthPlaqueRenderer.forEntity(entity).getSprite(false, false, false);
    }

    private static boolean isMount(LivingEntity entity) {
        Saddleable saddleable;
        return entity instanceof Saddleable && (saddleable = (Saddleable)entity).isSaddled();
    }

    public static Gui.HeartType forEntity(LivingEntity entity) {
        if (entity.hasEffect(MobEffects.POISON)) {
            return Gui.HeartType.POISIONED;
        }
        if (entity.hasEffect(MobEffects.WITHER)) {
            return Gui.HeartType.WITHERED;
        }
        if (entity.isFullyFrozen()) {
            return Gui.HeartType.FROZEN;
        }
        if (entity.getAbsorptionAmount() > 0.0f) {
            return Gui.HeartType.ABSORBING;
        }
        return Gui.HeartType.NORMAL;
    }
}

