/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import fuzs.moblassos.MobLassos;
import fuzs.moblassos.init.ModRegistry;
import fuzs.moblassos.network.ClientboundVillagerParticlesMessage;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ContractItem
extends Item {
    public ContractItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(this.getDescriptionComponent()));
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        AbstractVillager abstractVillager;
        ItemStack itemInHand = player.getItemInHand(hand);
        if (!itemInHand.is((Item)ModRegistry.CONTRACT_ITEM.value()) || !(entity instanceof AbstractVillager) || !(abstractVillager = (AbstractVillager)entity).isAlive()) return EventResultHolder.pass();
        if (ContractItem.canAcceptContract(abstractVillager)) {
            if (ModRegistry.VILLAGER_CONTRACT_ATTACHMENT_TYPE.has((Object)abstractVillager)) return EventResultHolder.pass();
            if (!level.isClientSide) {
                ModRegistry.VILLAGER_CONTRACT_ATTACHMENT_TYPE.set((Object)abstractVillager, (Object)Unit.INSTANCE);
                if (!player.getAbilities().instabuild) {
                    itemInHand.shrink(1);
                }
            }
            ContractItem.onUseContract(level, player, abstractVillager, itemInHand, true);
            return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        } else {
            if (!level.isClientSide) {
                abstractVillager.setUnhappyCounter(40);
                abstractVillager.playSound(SoundEvents.VILLAGER_NO, 1.0f, abstractVillager.getVoicePitch());
            }
            ContractItem.onUseContract(level, player, abstractVillager, ItemStack.EMPTY, false);
        }
        return EventResultHolder.interrupt((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
    }

    private static void onUseContract(Level level, Player player, AbstractVillager abstractVillager, ItemStack itemInHand, boolean happyParticles) {
        if (!level.isClientSide) {
            abstractVillager.notifyTradeUpdated(itemInHand);
            MobLassos.NETWORK.sendToAllTracking((Entity)abstractVillager, (ClientboundMessage)new ClientboundVillagerParticlesMessage(abstractVillager.getId(), happyParticles), false);
        }
        Component displayName = ContractItem.getVillagerDisplayName(abstractVillager);
        player.displayClientMessage((Component)Component.translatable((String)(((Item)ModRegistry.CONTRACT_ITEM.value()).getDescriptionId() + "." + (happyParticles ? "accept" : "reject")), (Object[])new Object[]{displayName}).withStyle(happyParticles ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    private static Component getVillagerDisplayName(AbstractVillager abstractVillager) {
        if (abstractVillager instanceof Villager) {
            Villager villager = (Villager)abstractVillager;
            MutableComponent merchantLevel = Component.translatable((String)("merchant.level." + villager.getVillagerData().getLevel()));
            return Component.empty().append(abstractVillager.getDisplayName()).append(" (").append((Component)merchantLevel).append(")");
        }
        return abstractVillager.getDisplayName();
    }

    public static boolean canAcceptContract(AbstractVillager abstractVillager) {
        if (abstractVillager instanceof Villager) {
            Villager villager = (Villager)abstractVillager;
            return Math.abs(villager.getUUID().getLeastSignificantBits() % 5L) < (long)villager.getVillagerData().getLevel();
        }
        return true;
    }
}

