/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;

public class LassoMobHelper {
    private static final List<String> TAGS_TO_REMOVE = List.of("puzzleslib:spawn_type", "forge:spawn_type", "neoforge:spawn_type", "SleepingX", "SleepingY", "SleepingZ");

    public static CompoundTag saveEntity(Entity entity) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
        entity.saveWithoutId(compoundTag);
        return compoundTag;
    }

    public static void moveEntityTo(Entity entity, Level level, BlockPos pos, boolean shouldOffsetY) {
        double offsetY;
        if (shouldOffsetY) {
            entity.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            offsetY = LassoMobHelper.getYOffset((LevelReader)level, pos, entity.getBoundingBox());
        } else {
            offsetY = 0.0;
        }
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5, Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.yHeadRot = mob.getYRot();
            mob.yBodyRot = mob.getYRot();
            mob.playAmbientSound();
        }
    }

    private static double getYOffset(LevelReader level, BlockPos pos, AABB box) {
        AABB aabb = new AABB(pos);
        Iterable iterable = level.getCollisions(null, aabb);
        return 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)box, (Iterable)iterable, (double)-1.0);
    }

    public static void removeTagKeys(ServerLevel level, CompoundTag compoundTag) {
        TAGS_TO_REMOVE.forEach(arg_0 -> ((CompoundTag)compoundTag).remove(arg_0));
        if (level.getEntity(compoundTag.getUUID("UUID")) != null) {
            compoundTag.remove("UUID");
        }
    }
}

