/*
 * Decompiled with CFR 0.152.
 */
package fuzs.metalbundles.world.item;

import fuzs.iteminteractions.api.v1.ItemContentsHelper;
import fuzs.iteminteractions.api.v1.provider.ItemContentsBehavior;
import fuzs.metalbundles.init.ModRegistry;
import fuzs.metalbundles.world.item.container.MetalBundleProvider;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import org.apache.commons.lang3.math.Fraction;

public class MetalBundleItem
extends BundleItem {
    public static final String KEY_BUNDLE_CAPACITY = Items.BUNDLE.getDescriptionId() + ".capacity";

    public MetalBundleItem(Item.Properties properties) {
        super(properties);
    }

    public int getBarWidth(ItemStack itemStack) {
        return Math.min(1 + Mth.mulAndTruncate((Fraction)MetalBundleItem.getActualWeight(itemStack), (int)12), 13);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Fraction weight = MetalBundleItem.getActualWeight(itemStack);
        if (!Fraction.ZERO.equals((Object)weight)) {
            String s = new DecimalFormat("0").format(weight.floatValue() * 100.0f);
            tooltipComponents.add((Component)Component.translatable((String)KEY_BUNDLE_CAPACITY, (Object[])new Object[]{s}).withStyle(ChatFormatting.GRAY));
        }
    }

    public static Fraction getActualWeight(ItemStack itemStack) {
        Fraction weight = ((BundleContents)itemStack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).weight();
        ItemContentsBehavior itemContentsBehavior = ItemContentsHelper.getItemContentsBehavior((ItemStack)itemStack);
        if (itemContentsBehavior.provider().getType() == ModRegistry.METAL_BUNDLE_ITEM_CONTENTS_PROVIDER_TYPE.value()) {
            return weight.divideBy(((MetalBundleProvider)itemContentsBehavior.provider()).getCapacityMultiplier());
        }
        return weight;
    }
}

