/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.IContentsListener;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityTurbineVent
extends TileEntityTurbineCasing {
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, @Nullable Direction>> capabilityCaches = new EnumMap<Direction, BlockCapabilityCache<IFluidHandler, Direction>>(Direction.class);

    public TileEntityTurbineVent(BlockPos pos, BlockState state) {
        super((Holder<Block>)GeneratorsBlocks.TURBINE_VENT, pos, state);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> {
            TurbineMultiblockData multiblock = (TurbineMultiblockData)this.getMultiblock();
            return multiblock.isFormed() ? multiblock.ventTanks : Collections.emptyList();
        };
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.FLUID) {
            return false;
        }
        return super.persists(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addFluidTargetCapability(List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> outputTargets, Direction side) {
        @Nullable BlockCapabilityCache cache = this.capabilityCaches.get(side);
        if (cache == null) {
            cache = Capabilities.FLUID.createCache((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.capabilityCaches.put(side, (BlockCapabilityCache<IFluidHandler, Direction>)cache);
        }
        outputTargets.add(cache);
    }
}

