/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.registries;

import mekanism.api.text.ILangEntry;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismCreativeTabs;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsItems;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class GeneratorsCreativeTabs {
    public static final CreativeTabDeferredRegister CREATIVE_TABS = new CreativeTabDeferredRegister("mekanismgenerators", GeneratorsCreativeTabs::addToExistingTabs);
    public static final MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> GENERATORS = CREATIVE_TABS.registerMain((ILangEntry)GeneratorsLang.MEKANISM_GENERATORS, (Holder)GeneratorsBlocks.HEAT_GENERATOR.getItemHolder(), builder -> builder.backgroundTexture(MekanismGenerators.rl("textures/gui/creative_tab.png")).withSearchBar(50).withTabsBefore(new ResourceLocation[]{MekanismCreativeTabs.MEKANISM.getId()}).displayItems((displayParameters, output) -> {
        CreativeTabDeferredRegister.addToDisplay((ItemDeferredRegister)GeneratorsItems.ITEMS, (CreativeModeTab.Output)output);
        CreativeTabDeferredRegister.addToDisplay((BlockDeferredRegister)GeneratorsBlocks.BLOCKS, (CreativeModeTab.Output)output);
        CreativeTabDeferredRegister.addToDisplay((FluidDeferredRegister)GeneratorsFluids.FLUIDS, (CreativeModeTab.Output)output);
    }));

    private static void addToExistingTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (tabKey == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (BlockRegistryObject[])new BlockRegistryObject[]{GeneratorsBlocks.HEAT_GENERATOR, GeneratorsBlocks.SOLAR_GENERATOR, GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, GeneratorsBlocks.WIND_GENERATOR, GeneratorsBlocks.BIO_GENERATOR, GeneratorsBlocks.GAS_BURNING_GENERATOR});
        } else if (tabKey == CreativeModeTabs.REDSTONE_BLOCKS) {
            for (Holder item : GeneratorsBlocks.BLOCKS.getSecondaryEntries()) {
                BlockItem blockItem;
                Object object = item.value();
                if (!(object instanceof BlockItem) || !Attribute.has((Block)(blockItem = (BlockItem)object).getBlock(), Attributes.AttributeComparator.class)) continue;
                CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (Holder[])new Holder[]{item});
            }
        } else if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            CreativeTabDeferredRegister.addToDisplay((FluidDeferredRegister)GeneratorsFluids.FLUIDS, (CreativeModeTab.Output)event);
        } else if (tabKey == CreativeModeTabs.INGREDIENTS) {
            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (Holder[])new Holder[]{GeneratorsItems.HOHLRAUM, GeneratorsItems.SOLAR_PANEL});
        }
    }
}

