/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FormulaAttachment;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FormulaicCraftingSlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFormulaicAssemblicator
extends TileEntityConfigurableMachine
implements IHasMode {
    public static final Predicate<@NotNull ItemStack> FORMULA_SLOT_VALIDATOR = stack -> stack.getItem() instanceof ItemCraftingFormula;
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.create();
    private static final int BASE_TICKS_REQUIRED = 40;
    private int ticksRequired = 40;
    private int operatingTicks;
    private boolean usedEnergy = false;
    private boolean autoMode = false;
    private boolean isRecipe = false;
    private boolean stockControl = false;
    private boolean needsOrganize = true;
    private boolean canTryToMove = true;
    private final HashedItem[] stockControlMap = new HashedItem[18];
    private int pulseOperations;
    @NotNull
    public RecipeFormula formula = RecipeFormula.EMPTY;
    @Nullable
    private RecipeHolder<CraftingRecipe> cachedRecipe = null;
    @SyntheticComputerMethod(getter="getExcessRemainingItems")
    NonNullList<ItemStack> lastRemainingItems = EMPTY_LIST;
    private ItemStack lastFormulaStack = ItemStack.EMPTY;
    private ItemStack lastOutputStack = ItemStack.EMPTY;
    private MachineEnergyContainer<TileEntityFormulaicAssemblicator> energyContainer;
    private List<IInventorySlot> craftingGridSlots;
    private List<IInventorySlot> inputSlots;
    private List<IInventorySlot> outputSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFormulaItem"}, docPlaceholder="formula slot")
    BasicInventorySlot formulaSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityFormulaicAssemblicator(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.FORMULAIC_ASSEMBLICATOR, pos, state);
        this.configComponent.setupItemIOConfig(this.inputSlots, this.outputSlots, this.energySlot, false);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, this.formulaSlot));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        int slotX;
        int slotY;
        this.craftingGridSlots = new ArrayList<IInventorySlot>();
        this.inputSlots = new ArrayList<IInventorySlot>();
        this.outputSlots = new ArrayList<IInventorySlot>();
        IContentsListener inputSlotChanged = () -> {
            listener.onContentsChanged();
            this.needsOrganize = this.stockControl;
            this.canTryToMove = true;
        };
        IContentsListener listenAndRecheckRecipe = () -> {
            listener.onContentsChanged();
            this.recalculateRecipe();
        };
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this);
        this.formulaSlot = BasicInventorySlot.at(FORMULA_SLOT_VALIDATOR, listenAndRecheckRecipe, 6, 26, 1);
        builder.addSlot(this.formulaSlot).setSlotOverlay(SlotOverlay.FORMULA);
        for (slotY = 0; slotY < 2; ++slotY) {
            for (slotX = 0; slotX < 9; ++slotX) {
                int index = slotY * 9 + slotX;
                InputInventorySlot inputSlot = InputInventorySlot.at(stack -> {
                    HashedItem stockItem;
                    if (this.formula.isEmpty()) {
                        return true;
                    }
                    if (!this.formula.valid()) {
                        return false;
                    }
                    if (this.stockControl && (stockItem = this.stockControlMap[index]) != null) {
                        return stockItem.isSameItemSameComponents((ItemStack)stack);
                    }
                    return this.formula.isValidIngredient(this.level, (ItemStack)stack);
                }, ConstantPredicates.alwaysTrue(), inputSlotChanged, 8 + slotX * 18, 98 + slotY * 18);
                this.inputSlots.add(builder.addSlot(inputSlot));
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 3; ++slotX) {
                FormulaicCraftingSlot craftingSlot = FormulaicCraftingSlot.at(this::getAutoMode, listenAndRecheckRecipe, 26 + slotX * 18, 17 + slotY * 18);
                this.craftingGridSlots.add(builder.addSlot(craftingSlot));
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 2; ++slotX) {
                OutputInventorySlot outputSlot = OutputInventorySlot.at(listener, 116 + slotX * 18, 17 + slotY * 18);
                this.outputSlots.add(builder.addSlot(outputSlot));
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFormulaicAssemblicator)this).getLevel(), listener, 152, 76);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public BasicInventorySlot getFormulaSlot() {
        return this.formulaSlot;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.checkFormula();
            this.recalculateRecipe();
            if (!this.formula.isEmpty() && this.stockControl) {
                this.buildStockControlMap();
            }
        }
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.cachedRecipe = null;
            this.recalculateRecipe();
        }
        if (!this.formula.isEmpty() && this.stockControl && this.needsOrganize) {
            this.buildStockControlMap();
            this.organizeStock();
            this.needsOrganize = false;
        }
        this.energySlot.fillContainerOrConvert();
        if (this.getControlType() != IRedstoneControl.RedstoneControl.PULSE) {
            this.pulseOperations = 0;
        } else if (this.canFunction()) {
            ++this.pulseOperations;
        }
        this.checkFormula();
        if (this.autoMode && this.formula.isEmpty()) {
            this.nextMode();
        }
        long clientEnergyUsed = 0L;
        if (this.autoMode && !this.formula.isEmpty() && (this.getControlType() == IRedstoneControl.RedstoneControl.PULSE && this.pulseOperations > 0 || this.canFunction())) {
            boolean canOperate = true;
            if (!this.isRecipe) {
                canOperate = this.moveItemsToGrid();
            }
            if (canOperate) {
                this.isRecipe = true;
                if (this.operatingTicks >= this.ticksRequired) {
                    if (this.doSingleCraft()) {
                        this.operatingTicks = 0;
                        if (this.pulseOperations > 0) {
                            --this.pulseOperations;
                        }
                    }
                } else {
                    long energyPerTick = this.energyContainer.getEnergyPerTick();
                    if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL) == energyPerTick) {
                        clientEnergyUsed = this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        ++this.operatingTicks;
                    }
                }
            } else {
                this.operatingTicks = 0;
            }
        } else {
            this.operatingTicks = 0;
        }
        this.usedEnergy = clientEnergyUsed > 0L;
        return sendUpdatePacket;
    }

    private void checkFormula() {
        ItemStack formulaStack = this.formulaSlot.getStack();
        FormulaAttachment attachment = (FormulaAttachment)formulaStack.getOrDefault(MekanismDataComponents.FORMULA_HOLDER, (Object)FormulaAttachment.EMPTY);
        if (!attachment.isEmpty() && !attachment.invalid()) {
            if (this.formula.isEmpty() || this.lastFormulaStack != formulaStack) {
                this.formula = this.loadFormula(formulaStack, attachment);
            }
        } else {
            this.formula = RecipeFormula.EMPTY;
        }
        this.lastFormulaStack = this.formulaSlot.getStack();
    }

    private RecipeFormula loadFormula(ItemStack formulaStack, FormulaAttachment attachment) {
        RecipeFormula recipe = RecipeFormula.create(this.level, attachment);
        if (recipe.valid()) {
            if (!this.formula.isEmpty() && !this.formula.equals(recipe)) {
                this.operatingTicks = 0;
            }
            return recipe;
        }
        formulaStack = formulaStack.copy();
        formulaStack.set(MekanismDataComponents.FORMULA_HOLDER, (Object)attachment.asInvalid());
        this.formulaSlot.setStack(formulaStack);
        return RecipeFormula.EMPTY;
    }

    private void recalculateRecipe() {
        if (this.level != null && !this.isRemote()) {
            boolean wasRecipe = this.isRecipe;
            ItemStack previousOutput = this.lastOutputStack;
            NonNullList<ItemStack> previousRemaining = this.lastRemainingItems;
            if (this.hasValidFormula()) {
                RecipeHolder<CraftingRecipe> recipe = this.formula.recipe();
                if (recipe == null) {
                    this.isRecipe = false;
                    this.lastOutputStack = ItemStack.EMPTY;
                } else {
                    CraftingInput input = MekanismUtils.getCraftingInputSlots(3, 3, this.craftingGridSlots, true).input();
                    this.isRecipe = ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, this.level);
                    if (this.isRecipe) {
                        this.lastOutputStack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
                        this.lastRemainingItems = ((CraftingRecipe)recipe.value()).getRemainingItems((RecipeInput)input);
                    } else {
                        this.lastOutputStack = ItemStack.EMPTY;
                    }
                }
            } else {
                CraftingInput craftingInput = MekanismUtils.getCraftingInputSlots(3, 3, this.craftingGridSlots, true).input();
                this.lastRemainingItems = EMPTY_LIST;
                if (this.cachedRecipe == null || !((CraftingRecipe)this.cachedRecipe.value()).matches((RecipeInput)craftingInput, this.level)) {
                    this.cachedRecipe = MekanismRecipeType.getRecipeFor(RecipeType.CRAFTING, craftingInput, this.level).orElse(null);
                }
                if (this.cachedRecipe == null) {
                    this.lastOutputStack = ItemStack.EMPTY;
                } else {
                    this.lastOutputStack = ((CraftingRecipe)this.cachedRecipe.value()).assemble((RecipeInput)craftingInput, (HolderLookup.Provider)this.level.registryAccess());
                    this.lastRemainingItems = ((CraftingRecipe)this.cachedRecipe.value()).getRemainingItems((RecipeInput)craftingInput);
                }
                this.isRecipe = !this.lastOutputStack.isEmpty();
            }
            boolean recipeChanged = false;
            if (this.isRecipe != wasRecipe || !ItemStack.matches((ItemStack)this.lastOutputStack, (ItemStack)previousOutput) || this.lastRemainingItems.size() != previousRemaining.size()) {
                recipeChanged = true;
            } else {
                for (int i = 0; i < this.lastRemainingItems.size(); ++i) {
                    if (ItemStack.matches((ItemStack)((ItemStack)this.lastRemainingItems.get(i)), (ItemStack)((ItemStack)previousRemaining.get(i)))) continue;
                    recipeChanged = true;
                    break;
                }
            }
            if (recipeChanged) {
                this.needsOrganize = true;
                this.canTryToMove = true;
            }
        }
    }

    private boolean canMoveLastRemaining() {
        for (ItemStack it : this.lastRemainingItems) {
            if (it.isEmpty() || this.tryMoveToOutput(it, Action.SIMULATE)) continue;
            return false;
        }
        return true;
    }

    private boolean doSingleCraft() {
        ItemStack output = this.lastOutputStack;
        if (!output.isEmpty() && this.tryMoveToOutput(output, Action.SIMULATE) && this.canMoveLastRemaining()) {
            this.tryMoveToOutput(output, Action.EXECUTE);
            for (ItemStack remainingItem : this.lastRemainingItems) {
                if (remainingItem.isEmpty()) continue;
                this.tryMoveToOutput(remainingItem, Action.EXECUTE);
            }
            for (IInventorySlot craftingSlot : this.craftingGridSlots) {
                if (craftingSlot.isEmpty()) continue;
                MekanismUtils.logMismatchedStackSize(craftingSlot.shrinkStack(1, Action.EXECUTE), 1L);
            }
            if (!this.formula.isEmpty()) {
                this.moveItemsToGrid();
            }
            return true;
        }
        return false;
    }

    public boolean craftSingle() {
        boolean canOperate = true;
        if (!this.formula.matches(this.getLevel(), this.craftingGridSlots)) {
            canOperate = this.moveItemsToGrid();
        }
        return canOperate && this.doSingleCraft();
    }

    private boolean moveItemsToGrid() {
        if (!this.canTryToMove) {
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (this.formula.isIngredientInPos(this.level, recipeStack, i)) continue;
            if (recipeStack.isEmpty()) {
                HashSet<HashedItem> checkedTypes = null;
                for (int j = this.inputSlots.size() - 1; j >= 0; --j) {
                    IInventorySlot stockSlot = this.inputSlots.get(j);
                    if (stockSlot.isEmpty()) continue;
                    ItemStack stockStack = stockSlot.getStack();
                    HashedItem stockStackType = HashedItem.raw(stockStack);
                    if (checkedTypes != null && !checkedTypes.add(stockStackType)) continue;
                    if (this.formula.isIngredientInPos(this.level, stockStack, i)) {
                        recipeSlot.setStack(stockStack.copyWithCount(1));
                        MekanismUtils.logMismatchedStackSize(stockSlot.shrinkStack(1, Action.EXECUTE), 1L);
                        break;
                    }
                    if (checkedTypes != null) continue;
                    checkedTypes = new HashSet<HashedItem>();
                    checkedTypes.add(stockStackType);
                }
                if (!recipeSlot.isEmpty()) continue;
                ret = false;
                continue;
            }
            recipeStack = this.tryMoveToInput(recipeStack);
            recipeSlot.setStack(recipeStack);
            if (recipeStack.isEmpty()) continue;
            ret = false;
        }
        if (!ret) {
            this.canTryToMove = false;
        }
        return ret;
    }

    public void craftAll() {
        while (this.craftSingle()) {
        }
    }

    public void fillGrid() {
        if (!this.formula.isEmpty()) {
            this.moveItemsToGrid();
        }
    }

    public void emptyGrid() {
        if (this.formula.isEmpty()) {
            this.moveItemsToInput(true);
        }
    }

    private void moveItemsToInput(boolean forcePush) {
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (recipeStack.isEmpty() || !forcePush && (this.formula.isEmpty() || this.formula.isIngredientInPos(this.getLevel(), recipeStack, i))) continue;
            recipeSlot.setStack(this.tryMoveToInput(recipeStack));
        }
    }

    @Override
    public void nextMode() {
        if (this.autoMode) {
            this.operatingTicks = 0;
            this.autoMode = false;
            this.markForSave();
        } else if (!this.formula.isEmpty()) {
            this.moveItemsToInput(false);
            this.autoMode = true;
            this.markForSave();
        }
    }

    @Override
    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod
    public boolean hasRecipe() {
        return this.isRecipe;
    }

    @ComputerMethod(nameOverride="getRecipeProgress")
    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    @ComputerMethod
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public boolean getStockControl() {
        return this.stockControl;
    }

    public boolean getAutoMode() {
        return this.autoMode;
    }

    public void toggleStockControl() {
        if (!this.isRemote() && !this.formula.isEmpty()) {
            boolean bl = this.stockControl = !this.stockControl;
            if (this.stockControl) {
                this.organizeStock();
            }
            this.needsOrganize = false;
        }
    }

    private void organizeStock() {
        if (this.formula.isEmpty()) {
            return;
        }
        Object2IntLinkedOpenHashMap storedMap = new Object2IntLinkedOpenHashMap();
        for (IInventorySlot inputSlot : this.inputSlots) {
            if (inputSlot.isEmpty()) continue;
            ItemStack stack = inputSlot.getStack();
            HashedItem hashed = HashedItem.create(stack);
            storedMap.mergeInt((Object)hashed, stack.getCount(), Integer::sum);
        }
        IntArraySet unused = new IntArraySet(this.stockControlMap.length);
        for (int i = 0; i < this.inputSlots.size(); ++i) {
            HashedItem hashedItem = this.stockControlMap[i];
            if (hashedItem == null) {
                unused.add(i);
                continue;
            }
            IInventorySlot slot = this.inputSlots.get(i);
            int stored = storedMap.getInt((Object)hashedItem);
            if (stored > 0) {
                int count = Math.min(hashedItem.getMaxStackSize(), stored);
                if (count == stored) {
                    storedMap.removeInt((Object)hashedItem);
                } else {
                    storedMap.put((Object)hashedItem, stored - count);
                }
                TileEntityFormulaicAssemblicator.setSlotIfChanged(slot, hashedItem, count);
                continue;
            }
            if (slot.isEmpty()) continue;
            slot.setEmpty();
        }
        boolean empty = storedMap.isEmpty();
        IntIterator intIterator = unused.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            IInventorySlot slot = this.inputSlots.get(i);
            if (empty) {
                if (slot.isEmpty()) continue;
                slot.setEmpty();
                continue;
            }
            empty = this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, slot);
        }
        if (empty) {
            return;
        }
        for (IInventorySlot inputSlot : this.inputSlots) {
            if (!inputSlot.isEmpty() || !this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, inputSlot)) continue;
            return;
        }
        if (!storedMap.isEmpty()) {
            Mekanism.logger.error("Critical error: Formulaic Assemblicator had items left over after organizing stock. Impossible!");
        }
    }

    private boolean setSlotIfChanged(Object2IntMap<HashedItem> storedMap, IInventorySlot inputSlot) {
        boolean empty = false;
        ObjectIterator iterator = Object2IntMaps.fastIterator(storedMap);
        Object2IntMap.Entry next = (Object2IntMap.Entry)iterator.next();
        HashedItem item = (HashedItem)next.getKey();
        int stored = next.getIntValue();
        int count = Math.min(item.getMaxStackSize(), stored);
        if (count == stored) {
            iterator.remove();
            empty = storedMap.isEmpty();
        } else {
            next.setValue(stored - count);
        }
        TileEntityFormulaicAssemblicator.setSlotIfChanged(inputSlot, item, count);
        return empty;
    }

    private static void setSlotIfChanged(IInventorySlot slot, HashedItem item, int count) {
        ItemStack stack = item.createStack(count);
        if (!ItemStack.matches((ItemStack)slot.getStack(), (ItemStack)stack)) {
            slot.setStack(stack);
        }
    }

    private void buildStockControlMap() {
        if (this.formula.isEmpty()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            HashedItem hashedItem;
            int j = i * 2;
            ItemStack stack = this.formula.getInputStack(i);
            if (stack.isEmpty()) {
                this.stockControlMap[j] = null;
                this.stockControlMap[j + 1] = null;
                continue;
            }
            this.stockControlMap[j] = hashedItem = HashedItem.create(stack);
            this.stockControlMap[j + 1] = hashedItem;
        }
    }

    private ItemStack tryMoveToInput(ItemStack stack) {
        return InventoryUtils.insertItem(this.inputSlots, stack, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private boolean tryMoveToOutput(ItemStack stack, Action action) {
        stack = InventoryUtils.insertItem(this.outputSlots, stack, action, AutomationType.INTERNAL);
        return stack.isEmpty();
    }

    public void encodeFormula() {
        RecipeFormula formula;
        if (this.formulaSlot.isEmpty()) {
            return;
        }
        FormulaAttachment formulaAttachment = (FormulaAttachment)this.formulaSlot.getStack().getOrDefault(MekanismDataComponents.FORMULA_HOLDER, (Object)FormulaAttachment.EMPTY);
        if (formulaAttachment.isEmpty() && (formula = RecipeFormula.create(this.level, this.craftingGridSlots)).valid()) {
            ItemStack stack = this.formulaSlot.getStack().copy();
            stack.set(MekanismDataComponents.FORMULA_HOLDER, (Object)FormulaAttachment.create(formula));
            this.formulaSlot.setStack(stack);
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.autoMode = nbt.getBoolean("auto");
        this.operatingTicks = nbt.getInt("progress");
        this.pulseOperations = nbt.getInt("pulse");
        this.stockControl = nbt.getBoolean("stock_control");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putBoolean("auto", this.autoMode);
        nbtTags.putInt("progress", this.operatingTicks);
        nbtTags.putInt("pulse", this.pulseOperations);
        nbtTags.putBoolean("stock_control", this.stockControl);
    }

    @Override
    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 40);
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityFormulaicAssemblicator> getEnergyContainer() {
        return this.energyContainer;
    }

    public boolean usedEnergy() {
        return this.usedEnergy;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getAutoMode, value -> {
            this.autoMode = value;
        }));
        container.track(SyncableInt.create(this::getOperatingTicks, value -> {
            this.operatingTicks = value;
        }));
        container.track(SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
        container.track(SyncableBoolean.create(this::hasRecipe, value -> {
            this.isRecipe = value;
        }));
        container.track(SyncableBoolean.create(this::getStockControl, value -> {
            this.stockControl = value;
        }));
        container.track(SyncableBoolean.create(this::usedEnergy, value -> {
            this.usedEnergy = value;
        }));
        int i = 0;
        while (i < 9) {
            int index = i++;
            container.track(SyncableItemStack.create(() -> this.formula.getInputStack(index), stack -> {
                this.formula = this.formula.withStack(this.getLevel(), index, (ItemStack)stack);
            }));
        }
    }

    @ComputerMethod
    public boolean hasValidFormula() {
        return !this.formula.isEmpty() && this.formula.valid();
    }

    @ComputerMethod
    ItemStack getCraftingInputSlot(int slot) throws ComputerException {
        if (slot < 0 || slot >= this.craftingGridSlots.size()) {
            throw new ComputerException("Crafting Input Slot '%d' is out of bounds, must be between 0 and %d.", slot, this.craftingGridSlots.size());
        }
        return this.craftingGridSlots.get(slot).getStack();
    }

    @ComputerMethod
    int getCraftingOutputSlots() {
        return this.outputSlots.size();
    }

    @ComputerMethod
    ItemStack getCraftingOutputSlot(int slot) throws ComputerException {
        int size = this.getCraftingOutputSlots();
        if (slot < 0 || slot >= size) {
            throw new ComputerException("Crafting Output Slot '%d' is out of bounds, must be between 0 and %d.", slot, size);
        }
        return this.outputSlots.get(slot).getStack();
    }

    @ComputerMethod(nameOverride="getSlots")
    int computerGetSlots() {
        return this.inputSlots.size();
    }

    @ComputerMethod
    ItemStack getItemInSlot(int slot) throws ComputerException {
        int size = this.computerGetSlots();
        if (slot < 0 || slot >= size) {
            throw new ComputerException("Slot '%d' is out of bounds, must be between 0 and %d.", slot, size);
        }
        return this.inputSlots.get(slot).getStack();
    }

    @ComputerMethod(nameOverride="encodeFormula", requiresPublicSecurity=true, methodDescription="Requires an unencoded formula in the formula slot and a valid recipe")
    void computerEncodeFormula() throws ComputerException {
        this.validateSecurityIsPublic();
        FormulaAttachment formulaAttachment = (FormulaAttachment)this.formulaSlot.getStack().getOrDefault(MekanismDataComponents.FORMULA_HOLDER, (Object)FormulaAttachment.EMPTY);
        if (formulaAttachment.isEmpty()) {
            throw new ComputerException("No formula found.");
        }
        if (this.hasValidFormula() || formulaAttachment.hasItems()) {
            throw new ComputerException("Formula has already been encoded.");
        }
        if (!this.hasRecipe()) {
            throw new ComputerException("Encoding formulas require that there is a valid recipe to actually encode.");
        }
        this.encodeFormula();
    }

    @ComputerMethod(nameOverride="emptyGrid", requiresPublicSecurity=true, methodDescription="Requires auto mode to be disabled")
    void computerEmptyGrid() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.autoMode) {
            throw new ComputerException("Emptying the grid requires Auto-Mode to be disabled.");
        }
        this.emptyGrid();
    }

    @ComputerMethod(nameOverride="fillGrid", requiresPublicSecurity=true, methodDescription="Requires auto mode to be disabled")
    void computerFillGrid() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.autoMode) {
            throw new ComputerException("Filling the grid requires Auto-Mode to be disabled.");
        }
        this.fillGrid();
    }

    private void validateCanCraft() throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.hasRecipe()) {
            throw new ComputerException("Unable to perform craft as there is currently no matching recipe in the grid.");
        }
        if (this.autoMode) {
            throw new ComputerException("Unable to perform craft as Auto-Mode is enabled.");
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires recipe and auto mode to be disabled")
    void craftSingleItem() throws ComputerException {
        this.validateCanCraft();
        this.craftSingle();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires recipe and auto mode to be disabled")
    void craftAvailableItems() throws ComputerException {
        this.validateCanCraft();
        this.craftAll();
    }

    private void validateHasValidFormula(String operation) throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.hasValidFormula()) {
            throw new ComputerException("%s requires a valid formula.", operation);
        }
    }

    @ComputerMethod(nameOverride="getStockControl", requiresPublicSecurity=true, methodDescription="Requires valid encoded formula")
    boolean computerGetStockControl() throws ComputerException {
        this.validateHasValidFormula("Stock Control");
        return this.getStockControl();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires valid encoded formula")
    void setStockControl(boolean mode) throws ComputerException {
        this.validateHasValidFormula("Stock Control");
        if (this.stockControl != mode) {
            this.toggleStockControl();
        }
    }

    @ComputerMethod(nameOverride="getAutoMode", requiresPublicSecurity=true, methodDescription="Requires valid encoded formula")
    boolean computerGetAutoMode() throws ComputerException {
        this.validateHasValidFormula("Auto-Mode");
        return this.getAutoMode();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Requires valid encoded formula")
    void setAutoMode(boolean mode) throws ComputerException {
        this.validateHasValidFormula("Auto-Mode");
        if (this.autoMode != mode) {
            this.nextMode();
        }
    }
}

