/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityPersonalStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityPersonalChest
extends TileEntityPersonalStorage
implements LidBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();

    public TileEntityPersonalChest(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.PERSONAL_CHEST, pos, state);
    }

    @Override
    protected void onOpen(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected void onClose(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected ResourceLocation getStat() {
        return Stats.OPEN_CHEST;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.chestLidController.tickLid();
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    @Override
    public InteractionResult openGui(Player player) {
        BlockPos above = this.getBlockPos().above();
        if (this.level.getBlockState(above).isRedstoneConductor((BlockGetter)this.level, above)) {
            return InteractionResult.CONSUME;
        }
        return super.openGui(player);
    }
}

