/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.ISidedFluidHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.FluidTankFluidTank;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.proxy.ProxyFluidHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.upgrade.FluidTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFluidTank
extends TileEntityMekanism
implements IConfigurable,
IFluidContainerManager {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    public FluidTankFluidTank fluidTank;
    @Nullable
    private IExtendedFluidTank belowTank;
    private boolean resolvedBelowTank;
    private IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    public FluidTankTier tier;
    private int valve;
    @NotNull
    public FluidStack valveFluid = FluidStack.EMPTY;
    private List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> fluidHandlerBelow = Collections.emptyList();
    public float prevScale;
    private boolean needsPacket;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    private int lastLightLevel;
    private int lightUpdateDelay;

    public TileEntityFluidTank(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.tier = Attribute.getTier(this.getBlockHolder(), FluidTankTier.class);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(this.facingSupplier);
        this.fluidTank = FluidTankFluidTank.create(this, listener);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        this.inputSlot = FluidInventorySlot.input(this.fluidTank, listener, 146, 19);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(listener, 146, 51);
        builder.addSlot(this.outputSlot);
        this.inputSlot.setSlotOverlay(SlotOverlay.INPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.OUTPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.checkLight();
    }

    private void checkLight() {
        if (this.lightUpdateDelay > 0) {
            int lightLevel;
            --this.lightUpdateDelay;
            if (this.lightUpdateDelay == 0 && (lightLevel = this.getBlockState().getLightEmission((BlockGetter)this.level, this.worldPosition)) != this.lastLightLevel) {
                this.lastLightLevel = lightLevel;
                this.level.getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.valve > 0) {
            --this.valve;
            if (this.valve == 0) {
                this.valveFluid = FluidStack.EMPTY;
                this.needsPacket = true;
            }
        }
        this.checkLight();
        float scale = MekanismUtils.getScale(this.prevScale, this.fluidTank);
        if (MekanismUtils.scaleChanged(scale, this.prevScale)) {
            if ((this.prevScale == 0.0f || scale == 0.0f) && this.lightUpdateDelay == 0) {
                this.lightUpdateDelay = this.prevScale == 0.0f ? 1 : MekanismConfig.general.blockDeactivationDelay.get();
            }
            this.prevScale = scale;
            sendUpdatePacket = true;
        }
        this.inputSlot.handleTank(this.outputSlot, this.editMode);
        if (this.getActive()) {
            IExtendedFluidTank below;
            if (this.fluidHandlerBelow.isEmpty()) {
                this.fluidHandlerBelow = List.of(Capabilities.FLUID.createCache((ServerLevel)this.level, this.worldPosition.below(), Direction.UP, ConstantPredicates.ALWAYS_TRUE, () -> {
                    this.resolvedBelowTank = false;
                    this.belowTank = null;
                }));
            }
            if ((below = this.getBelowTank()) == null) {
                FluidUtils.emit(this.fluidHandlerBelow, this.fluidTank, this.tier.getOutput());
            } else {
                FluidUtils.emit(this.fluidHandlerBelow, this.fluidTank, Math.min(below.getNeeded(), this.tier.getOutput()));
            }
        }
        if (this.needsPacket) {
            sendUpdatePacket = true;
            this.needsPacket = false;
        }
        return sendUpdatePacket;
    }

    @Nullable
    private IExtendedFluidTank getBelowTank() {
        if (!this.resolvedBelowTank) {
            ProxyFluidHandler fluidHandler;
            ISidedFluidHandler iSidedFluidHandler;
            this.resolvedBelowTank = true;
            IFluidHandler belowHandler = (IFluidHandler)this.fluidHandlerBelow.getFirst().getCapability();
            if (belowHandler instanceof ProxyFluidHandler && (iSidedFluidHandler = (fluidHandler = (ProxyFluidHandler)belowHandler).getInternalHandler()) instanceof TileEntityFluidTank) {
                TileEntityFluidTank tank = (TileEntityFluidTank)iSidedFluidHandler;
                this.belowTank = tank.fluidTank;
            }
        }
        return this.belowTank;
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        NBTUtils.writeEnum(data, "edit_mode", this.editMode);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag data) {
        super.readSustainedData(provider, data);
        NBTUtils.setEnumIfPresent(data, "edit_mode", IFluidContainerManager.ContainerEditMode.BY_ID, mode -> {
            this.editMode = mode;
        });
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.EDIT_MODE, (Object)this.editMode);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.editMode = (IFluidContainerManager.ContainerEditMode)input.getOrDefault(MekanismDataComponents.EDIT_MODE, (Object)this.editMode);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @Override
    @NotNull
    public FluidStack insertFluid(int tank, @NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action) {
        return this.insertExcess(stack, side, action, super.insertFluid(tank, stack, side, action));
    }

    @Override
    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action) {
        return this.insertExcess(stack, side, action, super.insertFluid(stack, side, action));
    }

    private FluidStack insertExcess(@NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action, @NotNull FluidStack remainder) {
        if (side == Direction.UP && action.execute() && remainder.getAmount() < stack.getAmount() && !this.isRemote()) {
            if (this.valve == 0) {
                this.needsPacket = true;
            }
            this.valve = 20;
            this.valveFluid = stack.copyWithAmount(1);
        }
        return remainder;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.getLevel();
            if (world != null) {
                world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    @ComputerMethod
    public IFluidContainerManager.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void nextMode() {
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getNext();
        this.markForSave();
    }

    @Override
    public void previousMode() {
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious();
        this.setChanged();
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof FluidTankUpgradeData) {
            FluidTankUpgradeData data = (FluidTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.inputSlot.setStack(data.inputSlot.getStack());
            this.outputSlot.setStack(data.outputSlot.getStack());
            this.editMode = data.editMode;
            this.fluidTank.setStack(data.stored);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Override
    @NotNull
    public FluidTankUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new FluidTankUpgradeData(provider, this.redstone, this.inputSlot, this.outputSlot, this.editMode, this.fluidTank.getFluid(), this.getComponents());
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(IFluidContainerManager.ContainerEditMode.BY_ID, IFluidContainerManager.ContainerEditMode.BOTH, () -> this.editMode, value -> {
            this.editMode = value;
        }));
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        NBTUtils.setIntIfPresent(nbt, "delay", value -> {
            this.lightUpdateDelay = value;
        });
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        nbtTags.putInt("delay", this.lightUpdateDelay);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putFloat("scale", this.prevScale);
        CompoundTag fluidData = new CompoundTag();
        FluidStack fluid = this.fluidTank.getFluid();
        if (fluid.isEmpty()) {
            fluid = this.valveFluid;
        } else {
            fluidData.putInt("amount", fluid.getAmount());
        }
        if (!fluid.isEmpty()) {
            ResourceLocation key = RegistryUtils.getName(fluid.getFluidHolder());
            if (key == null) {
                Mekanism.logger.error("Attempted to sync a fluid tank that is storing an unregistered fluid. This should not happen, and likely indicates a porting bug.");
            } else {
                fluidData.putString("id", key.toString());
                if (!fluid.isComponentsPatchEmpty()) {
                    DataResult componentData = DataComponentPatch.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)fluid.getComponentsPatch());
                    if (componentData.isSuccess()) {
                        fluidData.put("data", (Tag)componentData.getOrThrow());
                    } else {
                        componentData.ifError(error -> Mekanism.logger.error("Failed to encode fluid stack component data: {}", (Object)error.message()));
                    }
                }
                fluidData.putBoolean("valve", !this.valveFluid.isEmpty());
                updateTag.put("fluid", (Tag)fluidData);
            }
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        CompoundTag fluidData;
        super.handleUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            if (this.lightUpdateDelay == 0 && MekanismUtils.scaleChanged(this.prevScale, scale) && (this.prevScale == 0.0f || scale == 0.0f)) {
                this.lightUpdateDelay = this.prevScale == 0.0f ? 1 : MekanismConfig.general.blockDeactivationDelay.get();
            }
            this.prevScale = scale;
        });
        boolean unsetFluid = true;
        if (tag.contains("fluid", 10) && !(fluidData = tag.getCompound("fluid")).isEmpty()) {
            String fluidId = fluidData.getString("id");
            Optional holder = Optional.ofNullable(ResourceLocation.tryParse((String)fluidId)).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getHolder(arg_0));
            if (holder.isEmpty()) {
                Mekanism.logger.info("Received update packet for a fluid tank for an unregistered fluid with expected id: {}", (Object)fluidId);
            } else {
                Holder.Reference fluidType = (Holder.Reference)holder.get();
                DataComponentPatch patch = DataComponentPatch.EMPTY;
                int amount = fluidData.getInt("amount");
                if (fluidData.contains("data")) {
                    DataResult componentPatch = DataComponentPatch.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)fluidData.get("data"));
                    if (componentPatch.isSuccess()) {
                        patch = (DataComponentPatch)componentPatch.getOrThrow();
                    } else {
                        componentPatch.ifError(error -> Mekanism.logger.info("Received update packet for a fluid tank storing {}, and could not decode the data component patch: {}", (Object)fluidId, (Object)error.message()));
                    }
                }
                unsetFluid = false;
                if (amount == 0) {
                    this.fluidTank.setEmpty();
                } else {
                    this.fluidTank.setStack(new FluidStack((Holder)fluidType, amount, patch));
                }
                this.valveFluid = fluidData.getBoolean("valve") ? new FluidStack((Holder)fluidType, 1, patch) : FluidStack.EMPTY;
            }
        }
        if (unsetFluid) {
            this.fluidTank.setEmpty();
            this.valveFluid = FluidStack.EMPTY;
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.previousMode();
    }
}

