/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.NotNull;

public class CreativeTabDeferredRegister
extends MekanismDeferredRegister<CreativeModeTab> {
    private final Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs;

    public CreativeTabDeferredRegister(String modid) {
        this(modid, (BuildCreativeModeTabContentsEvent event) -> {});
    }

    public CreativeTabDeferredRegister(String modid, Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs) {
        super(Registries.CREATIVE_MODE_TAB, modid);
        this.addToExistingTabs = addToExistingTabs;
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(this.addToExistingTabs);
    }

    public MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> registerMain(ILangEntry title, Holder<Item> icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(this.getNamespace(), title, icon, operator);
    }

    public MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> register(String name, ILangEntry title, Holder<Item> icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(name, () -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().title((Component)title.translate()).icon(() -> new ItemStack(icon)).withTabFactory(MekanismCreativeTab::new);
            return ((CreativeModeTab.Builder)operator.apply(builder)).build();
        });
    }

    public static void addToDisplay(CreativeModeTab.Output output, Collection<? extends Holder<Item>> items, Predicate<Holder<Item>> shouldSkip) {
        for (Holder<Item> holder : items) {
            if (shouldSkip.test(holder)) continue;
            CreativeTabDeferredRegister.addToDisplay(output, holder);
        }
    }

    public static void addToDisplay(CreativeModeTab.Output output, BlockRegistryObject<?, ?> ... blocks) {
        CreativeTabDeferredRegister.addToDisplay(output, (Holder[])Arrays.stream(blocks).map(BlockRegistryObject::getItemHolder).toArray(Holder[]::new));
    }

    @SafeVarargs
    public static void addToDisplay(CreativeModeTab.Output output, Holder<Item> ... items) {
        CreativeModeTab.TabVisibility visibility = output instanceof BuildCreativeModeTabContentsEvent ? CreativeModeTab.TabVisibility.PARENT_TAB_ONLY : CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        for (Holder<Item> item : items) {
            Item itemLike = (Item)item.value();
            if (itemLike instanceof ICustomCreativeTabContents) {
                ICustomCreativeTabContents contents = (ICustomCreativeTabContents)itemLike;
                if (contents.addDefault()) {
                    output.accept((ItemLike)itemLike, visibility);
                }
                contents.addItems(item, stack -> output.accept(stack, visibility));
                continue;
            }
            output.accept((ItemLike)itemLike, visibility);
        }
    }

    public static void addToDisplay(ItemDeferredRegister register, CreativeModeTab.Output output) {
        CreativeTabDeferredRegister.addToDisplay(output, register.getEntries(), ConstantPredicates.alwaysFalse());
    }

    public static void addToDisplay(BlockDeferredRegister register, CreativeModeTab.Output output) {
        CreativeTabDeferredRegister.addToDisplay(output, register.getSecondaryEntries(), MekanismBlocks.BOUNDING_BLOCK::secondaryKeyMatches);
    }

    public static void addToDisplay(FluidDeferredRegister register, CreativeModeTab.Output output) {
        CreativeTabDeferredRegister.addToDisplay(output, register.getBucketEntries(), ConstantPredicates.alwaysFalse());
    }

    public static interface ICustomCreativeTabContents {
        public void addItems(Holder<Item> var1, Consumer<ItemStack> var2);

        default public boolean addDefault() {
            return true;
        }
    }

    public static class MekanismCreativeTab
    extends CreativeModeTab {
        protected MekanismCreativeTab(CreativeModeTab.Builder builder) {
            super(builder);
        }

        public int getLabelColor() {
            return SpecialColors.TEXT_TITLE.argb();
        }
    }
}

