/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.lookup.cache.type.BaseInputCache;

public abstract class ComponentSensitiveInputCache<KEY, INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe<?>>
extends BaseInputCache<KEY, INPUT, INGREDIENT, RECIPE> {
    private final Map<INPUT, List<RECIPE>> componentInputCache;

    protected ComponentSensitiveInputCache(Hash.Strategy<? super INPUT> componentHashStrategy) {
        this.componentInputCache = new Object2ObjectOpenCustomHashMap(0, 0.25f, componentHashStrategy);
    }

    @Override
    public void clear() {
        super.clear();
        this.componentInputCache.clear();
    }

    @Override
    public boolean contains(INPUT input) {
        return super.contains(input) || !this.componentInputCache.isEmpty() && this.componentInputCache.containsKey(input);
    }

    @Override
    public Iterable<RECIPE> getRecipes(INPUT input) {
        if (this.componentInputCache.isEmpty()) {
            return super.getRecipes(input);
        }
        List nbtRecipes = this.componentInputCache.getOrDefault(input, Collections.emptyList());
        if (nbtRecipes.isEmpty()) {
            return super.getRecipes(input);
        }
        Collection basicRecipes = (Collection)super.getRecipes(input);
        if (basicRecipes.isEmpty()) {
            return nbtRecipes;
        }
        return Iterables.concat(nbtRecipes, (Iterable)basicRecipes);
    }

    protected void addNbtInputCache(INPUT input, RECIPE recipe) {
        if (!this.componentInputCache.containsKey(input)) {
            this.componentInputCache.put(input, Collections.singletonList(recipe));
        } else {
            List<RECIPE> existing = this.componentInputCache.get(input);
            if (existing.size() == 1) {
                ArrayList<RECIPE> newList = new ArrayList<RECIPE>(existing);
                newList.add(recipe);
                this.componentInputCache.put(input, newList);
            } else {
                existing.add(recipe);
            }
        }
    }
}

