/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class NetworkAcceptorCache<ACCEPTOR> {
    private final Long2ObjectMap<Map<Direction, ACCEPTOR>> cachedAcceptors = new Long2ObjectOpenHashMap();
    private final Map<Transmitter<ACCEPTOR, ?, ?>, Set<Direction>> changedAcceptors = new Object2ObjectOpenHashMap();

    public void updateTransmitterOnSide(Transmitter<ACCEPTOR, ?, ?> transmitter, Direction side) {
        transmitter.refreshAcceptorConnections(side);
        Object acceptor = transmitter.canConnectToAcceptor(side) ? (Object)transmitter.getAcceptor(side) : null;
        long acceptorPos = WorldUtils.relativePos(transmitter.getWorldPositionLong(), side);
        if (acceptor == null) {
            Map cached = (Map)this.cachedAcceptors.get(acceptorPos);
            if (cached != null) {
                cached.remove(side.getOpposite());
                if (cached.isEmpty()) {
                    this.cachedAcceptors.remove(acceptorPos);
                }
            }
        } else {
            ((Map)this.cachedAcceptors.computeIfAbsent(acceptorPos, pos -> new EnumMap(Direction.class))).put(side.getOpposite(), acceptor);
        }
    }

    public void adoptAcceptors(NetworkAcceptorCache<ACCEPTOR> other) {
        ObjectIterator<Long2ObjectMap.Entry<Map<Direction, ACCEPTOR>>> iterator = other.getAcceptorFastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long pos = entry.getLongKey();
            if (this.cachedAcceptors.containsKey(pos)) {
                ((Map)this.cachedAcceptors.get(pos)).putAll((Map)entry.getValue());
                continue;
            }
            this.cachedAcceptors.put(pos, (Object)((Map)entry.getValue()));
        }
        for (Map.Entry<Transmitter<ACCEPTOR, ?, ?>, Set<Direction>> entry : other.changedAcceptors.entrySet()) {
            Transmitter<ACCEPTOR, ?, ?> transmitter = entry.getKey();
            if (this.changedAcceptors.containsKey(transmitter)) {
                this.changedAcceptors.get(transmitter).addAll((Collection<Direction>)entry.getValue());
                continue;
            }
            this.changedAcceptors.put(transmitter, entry.getValue());
        }
    }

    public void acceptorChanged(Transmitter<ACCEPTOR, ?, ?> transmitter, Direction side) {
        this.changedAcceptors.computeIfAbsent(transmitter, t -> EnumSet.noneOf(Direction.class)).add(side);
        TransmitterNetworkRegistry.registerChangedNetwork(transmitter.getTransmitterNetwork());
    }

    public void commit() {
        if (!this.changedAcceptors.isEmpty()) {
            for (Map.Entry<Transmitter<ACCEPTOR, ?, ?>, Set<Direction>> entry : this.changedAcceptors.entrySet()) {
                Transmitter<ACCEPTOR, ?, ?> transmitter = entry.getKey();
                if (!transmitter.isValid()) continue;
                for (Direction side : entry.getValue()) {
                    this.updateTransmitterOnSide(transmitter, side);
                }
            }
            this.changedAcceptors.clear();
        }
    }

    public void deregister() {
        this.cachedAcceptors.clear();
        this.changedAcceptors.clear();
    }

    public ObjectIterator<Long2ObjectMap.Entry<Map<Direction, ACCEPTOR>>> getAcceptorFastIterator() {
        return Long2ObjectMaps.fastIterator(this.cachedAcceptors);
    }

    public Collection<Map<Direction, ACCEPTOR>> getAcceptorValues() {
        return this.cachedAcceptors.values();
    }

    public int getAcceptorCount() {
        return this.cachedAcceptors.values().stream().mapToInt(Map::size).sum();
    }

    public boolean hasAcceptor(BlockPos acceptorPos) {
        return this.cachedAcceptors.containsKey(acceptorPos.asLong());
    }

    @Nullable
    public ACCEPTOR getCachedAcceptor(long acceptorPos, Direction side) {
        return (ACCEPTOR)((Map)this.cachedAcceptors.getOrDefault(acceptorPos, Collections.emptyMap())).get(side);
    }

    public Set<Direction> getAcceptorDirections(long pos) {
        return ((Map)this.cachedAcceptors.get(pos)).keySet();
    }
}

