/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.util.MekanismUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class SecurityUtils
implements ISecurityUtils {
    public static SecurityUtils get() {
        return (SecurityUtils)INSTANCE;
    }

    private boolean isOp(Player p) {
        ServerPlayer player;
        Objects.requireNonNull(p, "Player may not be null.");
        return MekanismConfig.general.opsBypassRestrictions.get() && p instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)(player = (ServerPlayer)p), MekanismPermissions.BYPASS_SECURITY, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
    }

    @Override
    public boolean canAccess(Player player, Supplier<@Nullable ISecurityObject> securityProvider, Supplier<@Nullable IOwnerObject> ownerProvider) {
        return this.isOp(player) || this.canAccess(player.getUUID(), securityProvider, ownerProvider, player.level().isClientSide);
    }

    @Override
    public <PROVIDER> boolean canAccess(Player player, PROVIDER provider, Function<PROVIDER, @Nullable ISecurityObject> securityProvider, Function<PROVIDER, @Nullable IOwnerObject> ownerProvider) {
        return this.isOp(player) || this.canAccess(player.getUUID(), provider, securityProvider, ownerProvider, player.level().isClientSide);
    }

    @Override
    public boolean canAccess(@Nullable UUID player, Supplier<@Nullable ISecurityObject> securityProvider, Supplier<@Nullable IOwnerObject> ownerProvider, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        ISecurityObject securityCapability = securityProvider.get();
        if (securityCapability == null) {
            IOwnerObject ownerCapability = ownerProvider.get();
            if (ownerCapability != null) {
                UUID owner = ownerCapability.getOwnerUUID();
                return owner == null || owner.equals(player);
            }
            return true;
        }
        return this.canAccessObject(player, securityCapability, isClient);
    }

    @Override
    public <PROVIDER> boolean canAccess(@Nullable UUID player, PROVIDER provider, Function<PROVIDER, @Nullable ISecurityObject> securityProvider, Function<PROVIDER, @Nullable IOwnerObject> ownerProvider, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        ISecurityObject securityCapability = securityProvider.apply(provider);
        if (securityCapability == null) {
            IOwnerObject ownerCapability = ownerProvider.apply(provider);
            if (ownerCapability != null) {
                UUID owner = ownerCapability.getOwnerUUID();
                return owner == null || owner.equals(player);
            }
            return true;
        }
        return this.canAccessObject(player, securityCapability, isClient);
    }

    @Override
    public boolean canAccessObject(Player player, ISecurityObject security) {
        return this.isOp(player) || this.canAccessObject(player.getUUID(), security, player.level().isClientSide);
    }

    @Override
    public boolean canAccessObject(@Nullable UUID player, ISecurityObject security, boolean isClient) {
        Objects.requireNonNull(security, "Security object may not be null.");
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        UUID owner = security.getOwnerUUID();
        if (owner == null || owner.equals(player)) {
            return true;
        }
        return switch (this.getEffectiveSecurityMode(security, isClient)) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> true;
            case SecurityMode.PRIVATE -> false;
            case SecurityMode.TRUSTED -> {
                if (player == null) {
                    yield false;
                }
                if (isClient) {
                    yield true;
                }
                SecurityFrequency frequency = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(owner);
                if (frequency != null && frequency.isTrusted(player)) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public boolean moreRestrictive(SecurityMode base, SecurityMode overridden) {
        Objects.requireNonNull(base, "Base security mode may not be null.");
        Objects.requireNonNull(base, "Override security mode may not be null.");
        return switch (overridden) {
            default -> throw new MatchException(null, null);
            case SecurityMode.PUBLIC -> false;
            case SecurityMode.PRIVATE -> {
                if (base != SecurityMode.PRIVATE) {
                    yield true;
                }
                yield false;
            }
            case SecurityMode.TRUSTED -> base == SecurityMode.PUBLIC;
        };
    }

    public SecurityData getFinalData(ISecurityObject securityObject, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return SecurityData.DUMMY;
        }
        SecurityData data = this.getData(securityObject.getOwnerUUID(), isClient);
        SecurityMode mode = securityObject.getSecurityMode();
        if (data.override() && this.moreRestrictive(mode, data.mode())) {
            return data;
        }
        return new SecurityData(mode, false);
    }

    private SecurityData getData(@Nullable UUID uuid, boolean isClient) {
        if (uuid == null) {
            return SecurityData.DUMMY;
        }
        if (isClient) {
            return MekanismClient.clientSecurityMap.getOrDefault(uuid, SecurityData.DUMMY);
        }
        SecurityFrequency frequency = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(uuid);
        return frequency == null ? SecurityData.DUMMY : new SecurityData(frequency);
    }

    @Override
    public SecurityMode getSecurityMode(Supplier<@Nullable ISecurityObject> securityProvider, Supplier<@Nullable IOwnerObject> ownerProvider, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return SecurityMode.PUBLIC;
        }
        ISecurityObject security = securityProvider.get();
        if (security != null) {
            return this.getEffectiveSecurityMode(security, isClient);
        }
        IOwnerObject ownerObject = ownerProvider.get();
        return ownerObject == null ? SecurityMode.PUBLIC : SecurityMode.PRIVATE;
    }

    @Override
    public <PROVIDER> SecurityMode getSecurityMode(PROVIDER provider, Function<PROVIDER, @Nullable ISecurityObject> securityProvider, Function<PROVIDER, @Nullable IOwnerObject> ownerProvider, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return SecurityMode.PUBLIC;
        }
        ISecurityObject security = securityProvider.apply(provider);
        if (security != null) {
            return this.getEffectiveSecurityMode(security, isClient);
        }
        IOwnerObject ownerObject = ownerProvider.apply(provider);
        return ownerObject == null ? SecurityMode.PUBLIC : SecurityMode.PRIVATE;
    }

    @Override
    public SecurityMode getEffectiveSecurityMode(ISecurityObject securityObject, boolean isClient) {
        Objects.requireNonNull(securityObject, "Security object may not be null.");
        return this.getFinalData(securityObject, isClient).mode();
    }

    public void incrementSecurityMode(Player player, @Nullable ISecurityObject security) {
        if (security != null && security.ownerMatches(player)) {
            security.setSecurityMode((SecurityMode)security.getSecurityMode().getNext());
        }
    }

    public void decrementSecurityMode(Player player, @Nullable ISecurityObject security) {
        if (security != null && security.ownerMatches(player)) {
            security.setSecurityMode((SecurityMode)security.getSecurityMode().getPrevious());
        }
    }

    @Override
    public void displayNoAccess(Player player) {
        Objects.requireNonNull(player, "Player may not be null.");
        player.sendSystemMessage(MekanismUtils.logFormat(EnumColor.RED, MekanismLang.NO_ACCESS));
    }

    public boolean isTrusted(SecurityMode mode, @Nullable UUID ownerUUID, UUID playerUUID) {
        if (ownerUUID != null && mode == SecurityMode.TRUSTED) {
            SecurityFrequency frequency = FrequencyType.SECURITY.getManager(null, SecurityMode.PUBLIC).getFrequency(ownerUUID);
            return frequency != null && frequency.isTrusted(playerUUID);
        }
        return false;
    }
}

