/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory.personalstorage;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.lib.MekanismSavedData;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageItemInventory;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
class PersonalStorageData
extends MekanismSavedData {
    private final Map<UUID, PersonalStorageItemInventory> inventoriesById = new HashMap<UUID, PersonalStorageItemInventory>();

    PersonalStorageData() {
    }

    PersonalStorageItemInventory getOrAddInventory(UUID id) {
        return this.inventoriesById.computeIfAbsent(id, unused -> this.createInventory());
    }

    PersonalStorageItemInventory addInventory(HolderLookup.Provider provider, UUID id, List<IInventorySlot> contents) {
        PersonalStorageItemInventory inventory = this.inventoriesById.get(id);
        if (inventory == null) {
            inventory = this.createInventory();
            this.inventoriesById.put(id, inventory);
            List<IInventorySlot> inventorySlots = inventory.getInventorySlots(null);
            int slots = contents.size();
            for (int i = 0; i < slots; ++i) {
                inventorySlots.get(i).deserializeNBT(provider, (Tag)contents.get(i).serializeNBT(provider));
            }
            this.setDirty();
        }
        return inventory;
    }

    void removeInventory(UUID id) {
        if (this.inventoriesById.remove(id) != null) {
            this.setDirty();
        }
    }

    @NotNull
    private PersonalStorageItemInventory createInventory() {
        return new PersonalStorageItemInventory(() -> ((PersonalStorageData)this).setDirty());
    }

    @Override
    public void load(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        ListTag entries = nbt.getList("data", 10);
        for (int i = 0; i < entries.size(); ++i) {
            CompoundTag entry = entries.getCompound(i);
            PersonalStorageItemInventory inv = this.createInventory();
            ContainerType.ITEM.readFrom(provider, entry, inv.getInventorySlots(null));
            this.inventoriesById.put(entry.getUUID("personal_storage_id"), inv);
        }
    }

    public CompoundTag save(CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        ListTag entries = new ListTag();
        for (Map.Entry<UUID, PersonalStorageItemInventory> entry : this.inventoriesById.entrySet()) {
            CompoundTag nbtEntry = new CompoundTag();
            nbtEntry.putUUID("personal_storage_id", entry.getKey());
            ContainerType.ITEM.saveTo(provider, nbtEntry, entry.getValue().getInventorySlots(null));
            entries.add((Object)nbtEntry);
        }
        compoundTag.put("data", (Tag)entries);
        return compoundTag;
    }

    public void save(File file, @NotNull HolderLookup.Provider provider) {
        File folder;
        if (this.isDirty() && !(folder = file.getParentFile()).exists() && !folder.mkdirs()) {
            Mekanism.logger.error("Could not create personal storage directory, saves may fail");
        }
        super.save(file, provider);
    }
}

