/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.ByteArrayPropertyData;
import net.minecraft.core.RegistryAccess;

public class SyncableByteArray
implements ISyncableData {
    private final Supplier<byte[]> getter;
    private final Consumer<byte[]> setter;
    private int lastKnownHashCode;

    public static SyncableByteArray create(Supplier<byte[]> getter, Consumer<byte[]> setter) {
        return new SyncableByteArray(getter, setter);
    }

    private SyncableByteArray(Supplier<byte[]> getter, Consumer<byte[]> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    public byte[] get() {
        return this.getter.get();
    }

    public void set(byte[] value) {
        this.setter.accept(value);
    }

    @Override
    public ByteArrayPropertyData getPropertyData(RegistryAccess registryAccess, short property, ISyncableData.DirtyType dirtyType) {
        byte[] bytes = this.get();
        return new ByteArrayPropertyData(property, Arrays.copyOf(bytes, bytes.length));
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        int valuesHashCode = Arrays.hashCode(this.get());
        if (this.lastKnownHashCode == valuesHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valuesHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }
}

