/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.framedblocks;

import mekanism.api.chemical.Chemical;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.integration.framedblocks.ChemicalParticleOptions;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

final class ChemicalSpriteParticle
extends TextureSheetParticle {
    private final BlockPos pos;
    private final float uo;
    private final float vo;
    private final int brightness;

    ChemicalSpriteParticle(ClientLevel level, double x, double y, double z, double sx, double sy, double sz, Holder<Chemical> chemical) {
        super(level, x, y, z, sx, sy, sz);
        this.pos = BlockPos.containing((double)x, (double)y, (double)z);
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        this.brightness = 0;
        int tint = MekanismRenderer.getTint(chemical);
        this.rCol = 0.6f * MekanismRenderer.getRed(tint);
        this.gCol = 0.6f * MekanismRenderer.getGreen(tint);
        this.bCol = 0.6f * MekanismRenderer.getBlue(tint);
        this.setSprite(MekanismRenderer.getChemicalTexture(chemical));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public int getLightColor(float partialTick) {
        int light = WorldUtils.isChunkLoaded((LevelReader)this.level, this.pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos) : 0;
        int block = Math.max(this.brightness, LightTexture.block((int)light));
        return LightTexture.pack((int)block, (int)LightTexture.sky((int)light));
    }

    static final class Provider
    implements ParticleProvider<ChemicalParticleOptions> {
        Provider() {
        }

        public Particle createParticle(ChemicalParticleOptions type, ClientLevel level, double x, double y, double z, double sx, double sy, double sz) {
            return new ChemicalSpriteParticle(level, x, y, z, sx, sy, sz, type.chemical());
        }
    }
}

