/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Separating")
public class ElectrolysisRecipeManager
extends MekanismRecipeManager<SingleFluidRecipeInput, ElectrolysisRecipe> {
    public static final ElectrolysisRecipeManager INSTANCE = new ElectrolysisRecipeManager();

    private ElectrolysisRecipeManager() {
        super(MekanismRecipeType.SEPARATING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient input, ICrTChemicalStack leftChemicalOutput, ICrTChemicalStack rightChemicalOutput, long energyMultiplier) {
        this.addRecipe(name, this.makeRecipe(input, leftChemicalOutput, rightChemicalOutput, energyMultiplier));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient input, ICrTChemicalStack leftChemicalOutput, ICrTChemicalStack rightChemicalOutput) {
        this.addRecipe(name, this.makeRecipe(input, leftChemicalOutput, rightChemicalOutput, 1L));
    }

    public final ElectrolysisRecipe makeRecipe(CTFluidIngredient input, ICrTChemicalStack leftChemicalOutput, ICrTChemicalStack rightChemicalOutput, long energyMultiplier) {
        if (energyMultiplier < 1L) {
            throw new IllegalArgumentException("Energy multiplier must be at least one! Multiplier: " + energyMultiplier);
        }
        return new BasicElectrolysisRecipe(CrTUtils.fromCrT(input), energyMultiplier, this.getAndValidateNotEmpty(leftChemicalOutput), this.getAndValidateNotEmpty(rightChemicalOutput));
    }

    @Override
    protected String describeOutputs(ElectrolysisRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition(), output -> String.valueOf(new CrTChemicalStack(output.left())) + " and " + String.valueOf(new CrTChemicalStack(output.right())));
    }
}

