/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class SorterFilter<FILTER extends SorterFilter<FILTER>>
extends BaseFilter<FILTER> {
    public static final int MAX_LENGTH = 48;
    @Nullable
    @SyntheticComputerMethod(getter="getColor", setter="setColor", threadSafeGetter=true, threadSafeSetter=true)
    public EnumColor color;
    @SyntheticComputerMethod(getter="getAllowDefault", setter="setAllowDefault", threadSafeGetter=true, threadSafeSetter=true)
    public boolean allowDefault;
    @SyntheticComputerMethod(getter="getSizeMode", setter="setSizeMode", threadSafeSetter=true, threadSafeGetter=true)
    public boolean sizeMode;
    @SyntheticComputerMethod(getter="getMin", threadSafeGetter=true)
    public int min;
    @SyntheticComputerMethod(getter="getMax", threadSafeGetter=true)
    public int max;

    protected static <FILTER extends SorterFilter<FILTER>> Products.P6<RecordCodecBuilder.Mu<FILTER>, Boolean, Boolean, Boolean, Integer, Integer, Optional<EnumColor>> baseSorterCodec(RecordCodecBuilder.Instance<FILTER> instance) {
        return SorterFilter.baseCodec(instance).and((App)Codec.BOOL.optionalFieldOf("allow_default", (Object)false).forGetter(filter -> filter.allowDefault)).and((App)Codec.BOOL.optionalFieldOf("size", (Object)false).forGetter(filter -> filter.sizeMode)).and((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("min", (Object)0).forGetter(filter -> filter.min)).and((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("max", (Object)0).forGetter(filter -> filter.max)).and((App)EnumColor.CODEC.optionalFieldOf("color").forGetter(filter -> Optional.ofNullable(filter.color)));
    }

    protected static <FILTER extends SorterFilter<FILTER>> StreamCodec<ByteBuf, FILTER> baseSorterStreamCodec(Supplier<FILTER> constructor) {
        return StreamCodec.composite(BaseFilter.baseStreamCodec(constructor), Function.identity(), (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.allowDefault, (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.sizeMode, (StreamCodec)ByteBufCodecs.VAR_INT, filter -> filter.min, (StreamCodec)ByteBufCodecs.VAR_INT, filter -> filter.max, EnumColor.OPTIONAL_STREAM_CODEC, filter -> Optional.ofNullable(filter.color), (filter, allowDefault, sizeMode, min, max, color) -> {
            filter.allowDefault = allowDefault;
            filter.color = color.orElse(null);
            filter.sizeMode = sizeMode;
            filter.min = min;
            filter.max = max;
            return filter;
        });
    }

    protected SorterFilter() {
    }

    protected SorterFilter(boolean enabled, boolean allowDefault, boolean sizeMode, int min, int max, @Nullable EnumColor color) {
        super(enabled);
        this.allowDefault = allowDefault;
        this.sizeMode = sizeMode;
        this.min = min;
        this.max = max;
        this.color = color;
    }

    protected SorterFilter(FILTER filter) {
        super(filter);
        this.allowDefault = ((SorterFilter)filter).allowDefault;
        this.color = ((SorterFilter)filter).color;
        this.sizeMode = ((SorterFilter)filter).sizeMode;
        this.min = ((SorterFilter)filter).min;
        this.max = ((SorterFilter)filter).max;
    }

    public abstract Finder getFinder();

    public TransitRequest mapInventory(IItemHandler itemHandler, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return TransitRequest.definedItem(itemHandler, this.min, this.max, this.getFinder());
        }
        return TransitRequest.definedItem(itemHandler, singleItem ? 1 : 99, this.getFinder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.allowDefault, this.sizeMode, this.min, this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterFilter other = (SorterFilter)o;
        return this.allowDefault == other.allowDefault && this.sizeMode == other.sizeMode && this.min == other.min && this.max == other.max && this.color == other.color;
    }

    @ComputerMethod(threadSafe=true)
    void setMinMax(int min, int max) throws ComputerException {
        if (min < 0 || max < 0 || min > max || max > 99) {
            throw new ComputerException("Invalid or min/max: 0 <= min <= max <= 99");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    @ComputerMethod(threadSafe=true)
    public abstract FILTER clone();
}

