/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.chemical.IChemicalTracker;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.content.network.distribution.ChemicalTransmitterSaveTarget;
import mekanism.common.content.network.transmitter.PressurizedTube;
import mekanism.common.lib.distribution.Target;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalNetwork
extends DynamicBufferedNetwork<IChemicalHandler, ChemicalNetwork, ChemicalStack, PressurizedTube>
implements IChemicalTracker {
    public final IChemicalTank chemicalTank;
    private final List<IChemicalTank> chemicalTanks;
    public Holder<Chemical> lastChemical = MekanismAPI.EMPTY_CHEMICAL_HOLDER;
    private long prevTransferAmount;

    public ChemicalNetwork(UUID networkID) {
        super(networkID);
        this.chemicalTank = VariableCapacityChemicalTank.createAllValid(this::getCapacity, (IContentsListener)this);
        this.chemicalTanks = Collections.singletonList(this.chemicalTank);
    }

    public ChemicalNetwork(Collection<ChemicalNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    @Override
    protected void forceScaleUpdate() {
        this.currentScale = !this.chemicalTank.isEmpty() && this.getCapacity() > 0L ? (float)Math.min(1.0, (double)this.chemicalTank.getStored() / (double)this.getCapacity()) : 0.0f;
    }

    @Override
    public List<PressurizedTube> adoptTransmittersAndAcceptorsFrom(ChemicalNetwork net) {
        float oldScale = this.currentScale;
        long oldCapacity = this.getCapacity();
        List<PressurizedTube> transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        long capacity = this.getCapacity();
        this.currentScale = Math.min(1.0f, capacity == 0L ? 0.0f : (this.currentScale * (float)oldCapacity + net.currentScale * (float)net.capacity) / (float)capacity);
        if (this.isRemote()) {
            if (this.chemicalTank.isEmpty()) {
                this.adoptBuffer(net);
            }
        } else {
            if (!net.chemicalTank.isEmpty()) {
                if (this.chemicalTank.isEmpty()) {
                    this.adoptBuffer(net);
                } else {
                    if (this.chemicalTank.isTypeEqual(net.chemicalTank.getStack())) {
                        long amount = net.chemicalTank.getStored();
                        MekanismUtils.logMismatchedStackSize(this.chemicalTank.growStack(amount, Action.EXECUTE), amount);
                    } else {
                        Mekanism.logger.error("Incompatible chemical networks merged: {}, {}.", (Object)this.chemicalTank.getStack(), (Object)net.chemicalTank.getStack());
                    }
                    net.chemicalTank.setEmpty();
                }
            }
            if (oldScale != this.currentScale) {
                this.needsUpdate = true;
            }
        }
        return transmittersToUpdate;
    }

    private void adoptBuffer(ChemicalNetwork net) {
        IChemicalTank other = net.getChemicalTank();
        this.chemicalTank.setStack(other.getStack().copy());
        other.setEmpty();
    }

    @Override
    @NotNull
    public ChemicalStack getBuffer() {
        return this.chemicalTank.getStack().copy();
    }

    @Override
    public void absorbBuffer(PressurizedTube transmitter) {
        ChemicalStack transmitterReleased = transmitter.releaseShare();
        if (!transmitterReleased.isEmpty()) {
            if (this.chemicalTank.isEmpty()) {
                this.chemicalTank.setStack(transmitterReleased.copy());
            } else if (this.chemicalTank.isTypeEqual(transmitterReleased)) {
                long amount = transmitterReleased.getAmount();
                MekanismUtils.logMismatchedStackSize(this.chemicalTank.growStack(amount, Action.EXECUTE), amount);
            }
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.chemicalTank.isEmpty()) {
            long capacity = this.getCapacity();
            if (this.chemicalTank.getStored() > capacity) {
                MekanismUtils.logMismatchedStackSize(this.chemicalTank.setStackSize(capacity, Action.EXECUTE), capacity);
            }
        }
    }

    @Override
    protected void updateSaveShares(@Nullable PressurizedTube triggerTransmitter) {
        super.updateSaveShares(triggerTransmitter);
        if (!this.isEmpty()) {
            this.updateSaveShares(triggerTransmitter, this.chemicalTank.getStack());
        }
    }

    private void updateSaveShares(@Nullable PressurizedTube triggerTransmitter, ChemicalStack chemical) {
        ChemicalTransmitterSaveTarget saveTarget = new ChemicalTransmitterSaveTarget(this.getTransmitters());
        long sent = EmitUtils.sendToAcceptors(saveTarget, chemical.getAmount(), chemical);
        if (triggerTransmitter != null && sent < chemical.getAmount()) {
            this.disperse(triggerTransmitter, chemical.copyWithAmount(chemical.getAmount() - sent));
        }
        saveTarget.saveShare();
    }

    @Override
    protected void onLastTransmitterRemoved(@NotNull PressurizedTube triggerTransmitter) {
        if (!this.chemicalTank.isEmpty()) {
            this.disperse(triggerTransmitter, this.chemicalTank.getStack());
        }
    }

    protected void disperse(@NotNull PressurizedTube triggerTransmitter, ChemicalStack stack) {
        IRadiationManager.INSTANCE.dumpRadiation(triggerTransmitter.getTileGlobalPos(), stack);
    }

    private long tickEmit(@NotNull ChemicalStack stack) {
        Collection acceptorValues = this.acceptorCache.getAcceptorValues();
        Target target = null;
        for (Map acceptors : acceptorValues) {
            for (IChemicalHandler handler : acceptors.values()) {
                if (!ChemicalUtil.canInsert(handler, stack)) continue;
                if (target == null) {
                    target = new ChemicalHandlerTarget(acceptorValues.size() * 2);
                }
                target.addHandler(handler);
            }
        }
        return EmitUtils.sendToAcceptors(target, stack.getAmount(), stack);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.needsUpdate) {
            NeoForge.EVENT_BUS.post((Event)new ChemicalTransferEvent(this, this.lastChemical));
            this.needsUpdate = false;
        }
        if (this.chemicalTank.isEmpty()) {
            this.prevTransferAmount = 0L;
        } else {
            this.prevTransferAmount = this.tickEmit(this.chemicalTank.getStack());
            MekanismUtils.logMismatchedStackSize(this.chemicalTank.shrinkStack(this.prevTransferAmount, Action.EXECUTE), this.prevTransferAmount);
        }
    }

    @Override
    protected float computeContentScale() {
        float scale = (float)((double)this.chemicalTank.getStored() / (double)this.getCapacity());
        float ret = Math.max(this.currentScale, scale);
        if (this.prevTransferAmount > 0L && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount <= 0L && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    public long getPrevTransferAmount() {
        return this.prevTransferAmount;
    }

    @Override
    public Component getNeededInfo() {
        return TextComponentUtil.build(this.chemicalTank.getNeeded());
    }

    @Override
    public Component getStoredInfo() {
        if (this.chemicalTank.isEmpty()) {
            return MekanismLang.NONE.translate();
        }
        return MekanismLang.NETWORK_MB_STORED.translate(this.chemicalTank.getStack(), this.chemicalTank.getStored());
    }

    @Override
    public Component getFlowInfo() {
        return MekanismLang.NETWORK_MB_PER_TICK.translate(this.prevTransferAmount);
    }

    @Override
    public boolean isCompatibleWith(ChemicalNetwork other) {
        if (super.isCompatibleWith(other)) {
            if (this.chemicalTank.isEmpty()) {
                return true;
            }
            return other.chemicalTank.isEmpty() || this.chemicalTank.isTypeEqual(other.chemicalTank.getStack());
        }
        return false;
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.CHEMICAL_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    public String toString() {
        return "[ChemicalNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
        if (!this.chemicalTank.isTypeEqual(this.lastChemical)) {
            if (!this.chemicalTank.isEmpty()) {
                this.lastChemical = this.chemicalTank.getTypeHolder();
            }
            this.needsUpdate = true;
        }
    }

    public void setLastChemical(@NotNull Holder<Chemical> chemical) {
        if (chemical.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
            if (!this.chemicalTank.isEmpty()) {
                this.chemicalTank.setEmpty();
            }
        } else {
            this.lastChemical = chemical;
            this.chemicalTank.setStack(new ChemicalStack(this.lastChemical, 1L));
        }
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        return this.chemicalTanks;
    }

    public static class ChemicalTransferEvent
    extends DynamicBufferedNetwork.TransferEvent<ChemicalNetwork> {
        public final Holder<Chemical> transferType;

        public ChemicalTransferEvent(ChemicalNetwork network, Holder<Chemical> type) {
            super(network);
            this.transferType = type;
        }
    }
}

