/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.util.RegistryUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;

public class MinerModIDFilter
extends MinerFilter<MinerModIDFilter>
implements IModIDFilter<MinerModIDFilter> {
    public static final MapCodec<MinerModIDFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> MinerModIDFilter.baseMinerCodec(instance).and((App)Codec.STRING.fieldOf("modid").forGetter(MinerModIDFilter::getModID)).apply((Applicative)instance, MinerModIDFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinerModIDFilter> STREAM_CODEC = StreamCodec.composite(MinerModIDFilter.baseMinerStreamCodec(MinerModIDFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, MinerModIDFilter::getModID, (filter, modID) -> {
        filter.modID = modID;
        return filter;
    });
    private String modID;

    public MinerModIDFilter() {
    }

    protected MinerModIDFilter(boolean enabled, Item replaceTarget, boolean requiresReplacement, String modID) {
        super(enabled, replaceTarget, requiresReplacement);
        this.modID = modID;
    }

    public MinerModIDFilter(MinerModIDFilter filter) {
        super(filter);
        this.modID = filter.modID;
    }

    @Override
    public boolean canFilter(BlockState state) {
        ResourceLocation name = RegistryUtils.getName(state.getBlockHolder());
        return name != null && WildcardMatcher.matches(this.modID, name.getNamespace());
    }

    @Override
    public boolean hasBlacklistedElement() {
        return TagCache.modIDHasMinerBlacklisted(this.modID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modID);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        MinerModIDFilter other = (MinerModIDFilter)o;
        return this.modID.equals(other.modID);
    }

    @Override
    public MinerModIDFilter clone() {
        return new MinerModIDFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MODID_FILTER;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

