/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNotNullByDefault
public final class Module<MODULE extends ICustomModule<MODULE>>
implements IModule<MODULE> {
    public static final Codec<Module<?>> CODEC = InstalledData.CODEC.dispatch(module -> new InstalledData(module.getDataHolder(), module.getInstalledCount()), installedData -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)installedData.configCodecs().forGetter(Module::getConfigs)).apply((Applicative)instance, installedData::create)));
    public static final StreamCodec<RegistryFriendlyByteBuf, Module<?>> STREAM_CODEC = InstalledData.STREAM_CODEC.dispatch(module -> new InstalledData(module.getDataHolder(), module.getInstalledCount()), installedData -> installedData.configStreamCodecs().map(installedData::create, Module::getConfigs));
    private final Map<ResourceLocation, ModuleConfig<?>> configItemsByName = new HashMap();
    private final List<ModuleConfig<?>> configItems;
    private final Holder<ModuleData<?>> holder;
    private final MODULE customModule;
    private final boolean enabled;
    private final boolean handleModeChange;
    private final boolean renderHUD;
    private final int installed;

    Module(Holder<ModuleData<?>> holder, int installed) {
        this(holder, installed, ((ModuleData)holder.value()).defaultConfigs(installed));
    }

    private Module(Holder<ModuleData<?>> holder, int installed, List<ModuleConfig<?>> configItems) {
        this.holder = holder;
        this.installed = installed;
        this.configItems = configItems;
        for (ModuleConfig<?> configItem : this.configItems) {
            this.configItemsByName.put(configItem.name(), configItem);
        }
        this.enabled = this.getBooleanConfigOrFalse(ModuleConfig.ENABLED_KEY);
        this.handleModeChange = this.getBooleanConfigOrFalse(ModuleConfig.HANDLES_MODE_CHANGE_KEY);
        this.renderHUD = this.getBooleanConfigOrFalse(ModuleConfig.RENDER_HUD_KEY);
        this.customModule = this.getData().create(this);
    }

    @Override
    public MODULE getCustomInstance() {
        return this.customModule;
    }

    public void tick(IModuleContainer moduleContainer, ItemStack stack, Player player) {
        if (this.isEnabled()) {
            if (player.level().isClientSide()) {
                this.customModule.tickClient(this, moduleContainer, stack, player);
            } else {
                this.customModule.tickServer(this, moduleContainer, stack, player);
            }
        }
    }

    @Override
    @Nullable
    public IEnergyContainer getEnergyContainer(ItemStack stack) {
        return StorageUtils.getEnergyContainer(stack, 0);
    }

    @Override
    public long getContainerEnergy(ItemStack stack) {
        IEnergyContainer energyContainer = this.getEnergyContainer(stack);
        return energyContainer == null ? 0L : energyContainer.getEnergy();
    }

    @Override
    public boolean hasEnoughEnergy(ItemStack stack, LongSupplier energySupplier) {
        return this.hasEnoughEnergy(stack, energySupplier.getAsLong());
    }

    @Override
    public boolean hasEnoughEnergy(ItemStack stack, long cost) {
        return cost == 0L || this.getContainerEnergy(stack) >= cost;
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, ItemStack stack, long energy) {
        return this.canUseEnergy(wearer, stack, energy, false);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, ItemStack stack, long energy, boolean ignoreCreative) {
        return this.canUseEnergy(wearer, this.getEnergyContainer(stack), energy, ignoreCreative);
    }

    @Override
    public boolean canUseEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, long energy, boolean ignoreCreative) {
        Player player;
        if (!(energyContainer == null || wearer.isSpectator() || ignoreCreative && wearer instanceof Player && (player = (Player)wearer).isCreative())) {
            return energyContainer.extract(energy, Action.SIMULATE, AutomationType.MANUAL) == energy;
        }
        return false;
    }

    @Override
    public long useEnergy(LivingEntity wearer, ItemStack stack, long energy) {
        return this.useEnergy(wearer, stack, energy, true);
    }

    @Override
    public long useEnergy(LivingEntity wearer, ItemStack stack, long energy, boolean freeCreative) {
        return this.useEnergy(wearer, this.getEnergyContainer(stack), energy, freeCreative);
    }

    @Override
    public long useEnergy(LivingEntity wearer, @Nullable IEnergyContainer energyContainer, long energy, boolean freeCreative) {
        Player player;
        if (!(energyContainer == null || freeCreative && wearer instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)wearer))) {
            return energyContainer.extract(energy, Action.EXECUTE, AutomationType.MANUAL);
        }
        return 0L;
    }

    @Override
    public ModuleData<?> getUntypedData() {
        return (ModuleData)this.holder.value();
    }

    @Override
    public Holder<ModuleData<?>> getDataHolder() {
        return this.holder;
    }

    @Override
    @Nullable
    public <TYPE> ModuleConfig<TYPE> getConfig(ResourceLocation name) {
        return this.configItemsByName.get(name);
    }

    public List<ModuleConfig<?>> getConfigs() {
        return this.configItems;
    }

    @Override
    public int getInstalledCount() {
        return this.installed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    Module<MODULE> withReplacedInstallCount(int installed) {
        List<ModuleConfig<?>> moduleConfigs = this.getUntypedData().defaultConfigs(installed);
        ArrayList copiedConfigs = new ArrayList(moduleConfigs.size());
        for (ModuleConfig<?> moduleConfig : moduleConfigs) {
            ResourceLocation name = moduleConfig.name();
            ModuleConfig<?> existingConfig = this.configItemsByName.get(name);
            if (existingConfig == null) {
                copiedConfigs.add(moduleConfig);
                continue;
            }
            if (moduleConfig.getClass() == existingConfig.getClass()) {
                copiedConfigs.add(this.configWithValue(moduleConfig, existingConfig));
                continue;
            }
            throw new IllegalStateException("Expected module config " + String.valueOf(name) + " to have the same class regardless of installed count.");
        }
        return new Module<MODULE>(this.holder, installed, List.copyOf(copiedConfigs));
    }

    private <CONFIG> ModuleConfig<CONFIG> configWithValue(ModuleConfig<CONFIG> defaultConfig, ModuleConfig<?> existing) {
        try {
            return defaultConfig.with(existing.get());
        }
        catch (IllegalArgumentException e) {
            return defaultConfig;
        }
    }

    Module<MODULE> withReplacedConfig(ModuleConfig<?> config) {
        return this.withReplacedConfig(config, false);
    }

    <CONFIG> Module<MODULE> withReplacedConfig(ModuleConfig<CONFIG> config, boolean fromPacket) {
        for (int i = 0; i < this.configItems.size(); ++i) {
            ModuleConfig<?> storedConfig = this.configItems.get(i);
            if (!storedConfig.name().equals((Object)config.name())) continue;
            if (storedConfig.get().equals(config.get())) {
                return this;
            }
            if (fromPacket) {
                if (storedConfig.getClass() != config.getClass()) {
                    throw new IllegalStateException("Config " + String.valueOf(config.name()) + "'s Class " + config.getClass().getSimpleName() + "  did not match " + storedConfig.getClass().getSimpleName());
                }
                config = storedConfig.with(config.get());
            }
            ArrayList copiedConfigs = new ArrayList(this.configItems);
            copiedConfigs.set(i, config);
            return new Module<MODULE>(this.holder, this.installed, List.copyOf(copiedConfigs));
        }
        throw new IllegalStateException("Could not find an existing config with name: " + String.valueOf(config.name()));
    }

    public void addHUDStrings(Player player, IModuleContainer moduleContainer, ItemStack stack, List<Component> list) {
        if (this.renderHUD) {
            this.customModule.addHUDStrings(this, moduleContainer, stack, player, list::add);
        }
    }

    public void addHUDElements(Player player, IModuleContainer moduleContainer, ItemStack stack, List<IHUDElement> list) {
        if (this.renderHUD) {
            this.customModule.addHUDElements(this, moduleContainer, stack, player, list::add);
        }
    }

    boolean handlesModeChangeRaw() {
        return this.handleModeChange;
    }

    @Override
    public boolean handlesModeChange() {
        return this.handleModeChange && (this.isEnabled() || this.customModule.canChangeModeWhenDisabled(this));
    }

    @Override
    public boolean handlesRadialModeChange() {
        if (this.getConfig(ModuleConfig.HANDLES_MODE_CHANGE_KEY) == null) {
            return false;
        }
        return this.isEnabled() || this.customModule.canChangeRadialModeWhenDisabled(this);
    }

    @Override
    public boolean handlesAnyModeChange() {
        if (this.getConfig(ModuleConfig.HANDLES_MODE_CHANGE_KEY) == null) {
            return false;
        }
        return this.isEnabled() || this.handleModeChange && this.customModule.canChangeModeWhenDisabled(this) || this.customModule.canChangeRadialModeWhenDisabled(this);
    }

    @Override
    public void displayModeChange(Player player, Component modeName, IHasTextComponent mode) {
        Component modeComponent = mode.getTextComponent();
        if (modeComponent.getStyle().getColor() != null) {
            player.displayClientMessage((Component)MekanismLang.MODULE_MODE_CHANGE.translate(modeName, modeComponent), true);
        } else {
            player.displayClientMessage((Component)MekanismLang.MODULE_MODE_CHANGE.translate(modeName, EnumColor.INDIGO, modeComponent), true);
        }
    }

    @Override
    public void toggleEnabled(IModuleContainer moduleContainer, ItemStack stack, Player player, Component modeName) {
        MutableComponent message = this.enabled ? MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.DARK_RED, MekanismLang.MODULE_DISABLED_LOWER) : MekanismLang.GENERIC_STORED.translate(modeName, EnumColor.BRIGHT_GREEN, MekanismLang.MODULE_ENABLED_LOWER);
        player.displayClientMessage((Component)message, true);
        ((ModuleContainer)moduleContainer).toggleEnabled((HolderLookup.Provider)player.registryAccess(), stack, this.holder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return this.installed == module.installed && this.getUntypedData() == module.getUntypedData() && this.configItems.equals(module.configItems);
    }

    public int hashCode() {
        return Objects.hash(this.configItems, this.getUntypedData(), this.installed);
    }

    private record InstalledData(Holder<ModuleData<?>> holder, int installed) {
        private static final Codec<InstalledData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MekanismAPI.MODULE_REGISTRY.holderByNameCodec().fieldOf("type").forGetter(InstalledData::holder), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(InstalledData::installed)).apply((Applicative)instance, InstalledData::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, InstalledData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry(MekanismAPI.MODULE_REGISTRY_NAME), InstalledData::holder, (StreamCodec)ByteBufCodecs.VAR_INT, InstalledData::installed, InstalledData::new);

        public Module<?> create(List<ModuleConfig<?>> configs) {
            return new Module(this.holder, this.installed, configs);
        }

        public MapCodec<List<ModuleConfig<?>>> configCodecs() {
            ModuleData data = (ModuleData)this.holder.value();
            return data.configCodecs(this.installed).optionalFieldOf("config", data.defaultConfigs(this.installed));
        }

        public StreamCodec<RegistryFriendlyByteBuf, List<ModuleConfig<?>>> configStreamCodecs() {
            return ((ModuleData)this.holder.value()).configStreamCodecs(this.installed);
        }
    }
}

