/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.laser.item;

import mekanism.api.lasers.ILaserDissipation;

public class LaserDissipationHandler
implements ILaserDissipation {
    private final double dissipationPercent;
    private final double refractionPercent;

    public static LaserDissipationHandler create(double dissipationPercent, double refractionPercent) {
        if (dissipationPercent < 0.0 || dissipationPercent > 1.0) {
            throw new IllegalArgumentException("Dissipation percent must be between zero and one inclusive");
        }
        if (refractionPercent < 0.0 || refractionPercent > 1.0) {
            throw new IllegalArgumentException("Refraction percent must be between zero and one inclusive");
        }
        return new LaserDissipationHandler(dissipationPercent, refractionPercent);
    }

    private LaserDissipationHandler(double dissipationPercent, double refractionPercent) {
        this.dissipationPercent = dissipationPercent;
        this.refractionPercent = refractionPercent;
    }

    @Override
    public double getDissipationPercent() {
        return this.dissipationPercent;
    }

    @Override
    public double getRefractionPercent() {
        return this.refractionPercent;
    }
}

