/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.RelativeSide;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigHolder<TYPE>
implements IHolder {
    private static final Predicate<ISlotInfo> CAN_INPUT = ISlotInfo::canInput;
    private static final Predicate<ISlotInfo> CAN_OUTPUT = ISlotInfo::canOutput;
    private static final ISlotInfo NO_CONFIG = new ISlotInfo(){

        @Override
        public boolean canInput() {
            return true;
        }

        @Override
        public boolean canOutput() {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "No Config";
        }
    };
    private final Map<Direction, ISlotInfo> cachedSlotInfo = new EnumMap<Direction, ISlotInfo>(Direction.class);
    private final ISideConfiguration sideConfiguration;
    protected final List<TYPE> slots = new ArrayList<TYPE>();
    @Nullable
    private Direction lastDirection;
    @Nullable
    private ConfigInfo lazyConfig;
    private boolean retrievedConfig;

    protected ConfigHolder(ISideConfiguration sideConfiguration) {
        this.sideConfiguration = sideConfiguration;
    }

    protected abstract TransmissionType getTransmissionType();

    @Override
    public boolean canInsert(@Nullable Direction side) {
        return this.canInteract(side, CAN_INPUT);
    }

    @Override
    public boolean canExtract(@Nullable Direction side) {
        return this.canInteract(side, CAN_OUTPUT);
    }

    private boolean canInteract(@Nullable Direction side, @NotNull Predicate<ISlotInfo> interactPredicate) {
        if (side == null) {
            return false;
        }
        ISlotInfo slotInfo = this.getSlotInfo(side);
        if (slotInfo == NO_CONFIG) {
            return true;
        }
        return slotInfo != null && interactPredicate.test(slotInfo);
    }

    @NotNull
    protected List<TYPE> getSlots(@Nullable Direction side, @NotNull Function<ISlotInfo, List<TYPE>> slotInfoParser) {
        if (side == null) {
            return this.slots;
        }
        ISlotInfo slotInfo = this.getSlotInfo(side);
        if (slotInfo == NO_CONFIG) {
            return this.slots;
        }
        if (slotInfo == null) {
            return Collections.emptyList();
        }
        return slotInfoParser.apply(slotInfo);
    }

    @Nullable
    private ISlotInfo getSlotInfo(Direction side) {
        ISlotInfo slotInfo;
        Direction direction = this.sideConfiguration.getDirection();
        if (direction != this.lastDirection) {
            this.cachedSlotInfo.clear();
            this.lastDirection = direction;
        } else if (this.cachedSlotInfo.containsKey(side)) {
            return this.cachedSlotInfo.get(side);
        }
        if (!this.retrievedConfig) {
            this.retrievedConfig = true;
            TileComponentConfig config = this.sideConfiguration.getConfig();
            if (config != null) {
                TransmissionType transmissionType = this.getTransmissionType();
                this.lazyConfig = config.getConfig(transmissionType);
                if (this.lazyConfig != null) {
                    config.addConfigChangeListener(transmissionType, this.cachedSlotInfo::remove);
                }
            }
        }
        if (this.lazyConfig == null) {
            slotInfo = NO_CONFIG;
        } else {
            slotInfo = this.lazyConfig.getSlotInfo(RelativeSide.fromDirections(direction, side));
            if (slotInfo != null && !slotInfo.isEnabled()) {
                slotInfo = null;
            }
        }
        this.cachedSlotInfo.put(side, slotInfo);
        return slotInfo;
    }
}

