/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.prefab;

import java.util.function.UnaryOperator;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeCustomShape;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.interfaces.IHasDescription;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBase<TYPE extends BlockType>
extends BlockMekanism
implements IHasDescription,
ITypeBlock {
    protected final TYPE type;
    private static BlockType cacheType;

    public BlockBase(TYPE type, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        this(type, (BlockBehaviour.Properties)propertyModifier.apply(BlockBehaviour.Properties.of().requiresCorrectToolForDrops()));
    }

    public BlockBase(TYPE type, BlockBehaviour.Properties properties) {
        super(BlockBase.hack(type, properties));
        this.type = type;
    }

    private static <TYPE extends BlockType> BlockBehaviour.Properties hack(TYPE type, BlockBehaviour.Properties props) {
        cacheType = type;
        for (Attribute a : type.getAll()) {
            a.adjustProperties(props);
        }
        return props;
    }

    @Override
    public final BlockType getType() {
        return this.type == null ? cacheType : this.type;
    }

    @Override
    @NotNull
    public ILangEntry getDescription() {
        return ((BlockType)this.type).getDescription();
    }

    @NotNull
    public MutableComponent getName() {
        BlockBase blockBase = this;
        if (blockBase instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)((Object)blockBase);
            return TextComponentUtil.build(coloredBlock.getColor(), super.getName());
        }
        BaseTier baseTier = Attribute.getBaseTier((Holder<Block>)this.builtInRegistryHolder());
        if (baseTier == null) {
            return super.getName();
        }
        return TextComponentUtil.build(baseTier.getColor(), super.getName());
    }

    public float getExplosionResistance(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        Attributes.AttributeCustomResistance customResistance = ((BlockType)this.type).get(Attributes.AttributeCustomResistance.class);
        return customResistance == null ? super.getExplosionResistance(state, world, pos, explosion) : customResistance.resistance();
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathType) {
        return !((BlockType)this.type).has(AttributeCustomShape.class) && super.isPathfindable(state, pathType);
    }

    @Nullable
    public PathType getBlockPathType(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Mob mob) {
        PathType pathType;
        Attributes.AttributeCustomPathType customPathType = ((BlockType)this.type).get(Attributes.AttributeCustomPathType.class);
        if (customPathType != null && (pathType = customPathType.pathCheck().getBlockPathType(state, level, pos, mob)) != null) {
            return pathType;
        }
        return super.getBlockPathType(state, level, pos, mob);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        AttributeCustomShape customShape = ((BlockType)this.type).get(AttributeCustomShape.class);
        if (customShape != null) {
            VoxelShape[] bounds = customShape.bounds();
            if (bounds.length == 1) {
                return bounds[0];
            }
            AttributeStateFacing attr = ((BlockType)this.type).get(AttributeStateFacing.class);
            int index = attr == null ? 0 : attr.getDirection(state).ordinal() - (attr.getFacingProperty() == BlockStateProperties.FACING ? 0 : 2);
            return bounds[index];
        }
        return super.getShape(state, world, pos, context);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.isShiftKeyDown() && MekanismUtils.canUseAsWrench(stack)) {
            if (!world.isClientSide) {
                WorldUtils.dismantleBlock(state, world, pos, (Entity)player, stack);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static class BlockBaseModel<BLOCK extends BlockType>
    extends BlockBase<BLOCK>
    implements IStateFluidLoggable {
        public BlockBaseModel(BLOCK blockType, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
            super(blockType, propertyModifier);
        }

        public BlockBaseModel(BLOCK blockType, BlockBehaviour.Properties properties) {
            super(blockType, properties);
        }
    }
}

