/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.qio;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.SerializerHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record PortableDashboardContents(List<ItemStack> contents) {
    public static final int TOTAL_SLOTS = 27;
    public static final PortableDashboardContents EMPTY = new PortableDashboardContents((List<ItemStack>)NonNullList.withSize((int)27, (Object)ItemStack.EMPTY));
    public static final Codec<PortableDashboardContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializerHelper.LENIENT_OPTIONAL_STACK_CODEC.listOf(27, 27).fieldOf("items").forGetter(PortableDashboardContents::contents)).apply((Applicative)instance, PortableDashboardContents::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PortableDashboardContents> STREAM_CODEC = ItemStack.OPTIONAL_LIST_STREAM_CODEC.map(PortableDashboardContents::new, PortableDashboardContents::contents);

    public PortableDashboardContents {
        contents = Collections.unmodifiableList(contents);
    }

    public PortableDashboardContents with(int window, int index, ItemStack stack) {
        ArrayList<ItemStack> copy = new ArrayList<ItemStack>(this.contents);
        copy.set(PortableDashboardContents.getIndex(window, index), stack);
        return new PortableDashboardContents(copy);
    }

    public ItemStack getSlotContents(int window, int index) {
        return this.contents.get(PortableDashboardContents.getIndex(window, index)).copy();
    }

    private static int getIndex(int window, int index) {
        return 9 * window + index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ItemStack.listMatches(this.contents, ((PortableDashboardContents)o).contents);
    }

    @Override
    public int hashCode() {
        return ItemStack.hashStackList(this.contents);
    }
}

