/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.energy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.containers.IAttachedContainers;
import net.minecraft.core.NonNullList;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record AttachedEnergy(List<Long> containers) implements IAttachedContainers<Long, AttachedEnergy>
{
    public static final AttachedEnergy EMPTY = new AttachedEnergy(Collections.emptyList());
    public static final Codec<AttachedEnergy> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializerHelper.POSITIVE_LONG_CODEC_LEGACY.listOf().fieldOf("energy_containers").forGetter(AttachedEnergy::containers)).apply((Applicative)instance, AttachedEnergy::new));
    public static final StreamCodec<ByteBuf, AttachedEnergy> STREAM_CODEC = ByteBufCodecs.VAR_LONG.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)).map(AttachedEnergy::new, AttachedEnergy::containers);

    public AttachedEnergy {
        containers = Collections.unmodifiableList(containers);
    }

    public static AttachedEnergy create(int containers) {
        return new AttachedEnergy((List<Long>)NonNullList.withSize((int)containers, (Object)0L));
    }

    @Override
    public Long getEmptyStack() {
        return 0L;
    }

    @Override
    public AttachedEnergy create(List<Long> containers) {
        return new AttachedEnergy(containers);
    }
}

