/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.lang.ref.WeakReference;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSound
extends AbstractTickableSoundInstance {
    @NotNull
    private final WeakReference<Player> playerReference;
    private final int subtitleFrequency;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float fadeUpStep = 0.1f;
    private float fadeDownStep = 0.1f;
    private int consecutiveTicks;

    public PlayerSound(@NotNull Player player, @NotNull SoundEventRegistryObject<?> sound) {
        this(player, (SoundEvent)sound.get(), 60);
    }

    public PlayerSound(@NotNull Player player, @NotNull SoundEvent sound, int subtitleFrequency) {
        super(sound, SoundSource.PLAYERS, player.level().getRandom());
        this.playerReference = new WeakReference<Player>(player);
        this.subtitleFrequency = subtitleFrequency;
        this.lastX = (float)player.getX();
        this.lastY = (float)player.getY();
        this.lastZ = (float)player.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.1f;
    }

    @Nullable
    private Player getPlayer() {
        return (Player)this.playerReference.get();
    }

    protected void setFade(float fadeUpStep, float fadeDownStep) {
        this.fadeUpStep = fadeUpStep;
        this.fadeDownStep = fadeDownStep;
    }

    public double getX() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastX = (float)player.getX();
        }
        return this.lastX;
    }

    public double getY() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastY = (float)player.getY();
        }
        return this.lastY;
    }

    public double getZ() {
        Player player = this.getPlayer();
        if (player != null) {
            this.lastZ = (float)player.getZ();
        }
        return this.lastZ;
    }

    public void tick() {
        Player player = this.getPlayer();
        if (player == null || !player.isAlive()) {
            this.stop();
            this.volume = 0.0f;
            this.consecutiveTicks = 0;
            return;
        }
        if (this.shouldPlaySound(player) && player.level().tickRateManager().runsNormally()) {
            if (this.volume < 1.0f) {
                this.volume = Math.min(1.0f, this.volume + this.fadeUpStep);
            }
            if (this.consecutiveTicks % this.subtitleFrequency == 0) {
                SoundManager soundHandler = Minecraft.getInstance().getSoundManager();
                if (!soundHandler.soundEngine.listeners.isEmpty()) {
                    float scaledVolume = Math.max(this.volume, 1.0f) * (float)this.sound.getAttenuationDistance();
                    float range = !this.relative && this.attenuation != SoundInstance.Attenuation.NONE ? scaledVolume : Float.POSITIVE_INFINITY;
                    for (SoundEventListener soundEventListener : soundHandler.soundEngine.listeners) {
                        WeighedSoundEvents soundEventAccessor = this.resolve(soundHandler);
                        if (soundEventAccessor == null) continue;
                        soundEventListener.onPlaySound((SoundInstance)this, soundEventAccessor, range);
                    }
                }
                this.consecutiveTicks = 1;
            } else {
                ++this.consecutiveTicks;
            }
        } else if (this.volume > 0.0f) {
            this.consecutiveTicks = 0;
            this.volume = Math.max(0.0f, this.volume - this.fadeDownStep);
        }
    }

    public abstract boolean shouldPlaySound(@NotNull Player var1);

    public float getVolume() {
        return super.getVolume() * MekanismConfig.client.baseSoundVolume.get();
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        Player player = this.getPlayer();
        if (player == null) {
            return super.canPlaySound();
        }
        return !player.isSilent();
    }

    public static enum SoundType {
        JETPACK,
        SCUBA_MASK,
        GRAVITATIONAL_MODULATOR;

    }
}

